local default_color = {b = 250, g = 186, r = 140}
local night_color = {b = 16, g = 0, r = 0}
local change_distance = ((minetest.settings):get("sky_color_change_distance") or 4)
local area_side = ((change_distance * 2) + 1)
local area_volume = (area_side ^ 3)
local biome_id = minetest.get_biome_id
local colors = {[biome_id("default:acidic_landscapes")] = {b = 100, g = 255, r = 255}, [biome_id("default:purple_swamp")] = {b = 255, g = 155, r = 190}, [biome_id("default:redland")] = {b = 150, g = 200, r = 255}, [biome_id("default:reptile_house")] = {b = 100, g = 255, r = 200}, [biome_id("default:swamp_connector")] = {b = 255, g = 155, r = 190}}
local sunrise = {finish = (5751 / 24000), start = (4500 / 24000)}
local sunset = {finish = (19502 / 24000), start = (18600 / 24000)}
local function brightness(color, x)
  return {b = (x * color.b), g = (x * color.g), r = (x * color.r)}
end
local function addition(c1, c2)
  return {b = math.min((c1.b + c2.b), 255), g = math.min((c1.g + c2.g), 255), r = math.min((c1.r + c2.r), 255)}
end
local function get_sky_color(color, timeofday)
  if (timeofday < sunrise.start) then
    return brightness(color, 0)
  elseif ((timeofday >= sunrise.start) and (timeofday < sunrise.finish)) then
    return brightness(color, ((timeofday - sunrise.start) / (sunrise.finish - sunrise.start)))
  elseif ((timeofday >= sunrise.finish) and (timeofday < sunset.start)) then
    return brightness(color, 1)
  elseif ((timeofday >= sunset.start) and (timeofday < sunset.finish)) then
    return brightness(color, ((sunset.finish - timeofday) / (sunset.finish - sunset.start)))
  elseif (timeofday >= sunset.finish) then
    return brightness(color, 0)
  end
end
local function get_color_at_pos(pos)
  return (colors[minetest.get_biome_data(pos).biome] or default_color)
end
local function calc_color(pos)
  local color = {b = 0, g = 0, r = 0}
  for x = (pos.x - change_distance), (pos.x + change_distance) do
    for y = (pos.y - change_distance), (pos.y + change_distance) do
      for z = (pos.z - change_distance), (pos.z + change_distance) do
        local color_e2_80_b2 = get_color_at_pos({x = x, y = y, z = z})
        color["r"] = (color.r + color_e2_80_b2.r)
        color["g"] = (color.g + color_e2_80_b2.g)
        color["b"] = (color.b + color_e2_80_b2.b)
      end
    end
  end
  return brightness(color, (1 / area_volume))
end
local function _0_(_)
  local timeofday = minetest.get_timeofday()
  for _0, player in ipairs(minetest.get_connected_players()) do
    local pos = player:get_pos()
    local color_e2_80_b2 = calc_color(pos)
    local color = addition(get_sky_color(color_e2_80_b2, timeofday), night_color)
    if default["enough-fresh?"] then
      player:set_sky({base_color = color, type = "plain"})
    else
      player:set_sky(color, "plain")
    end
  end
  return nil
end
return minetest.register_globalstep(_0_)
