local transformer_resis = 0.0001
local transformer_box = {fixed = {{(-1 / 2), (-1 / 2), (-1 / 2), (1 / 2), ((-1 / 2) + (2 / 16)), (1 / 2)}, {((-1 / 2) + (5 / 16)), ((-1 / 2) + (2 / 16)), ((-1 / 2) + (2 / 16)), ((1 / 2) - (5 / 16)), ((-1 / 2) + (4 / 16)), ((1 / 2) - (2 / 16))}, {((-1 / 2) + (5 / 16)), ((1 / 2) - (4 / 16)), ((-1 / 2) + (2 / 16)), ((1 / 2) - (5 / 16)), ((1 / 2) - (2 / 16)), ((1 / 2) - (2 / 16))}, {((-1 / 2) + (5 / 16)), ((-1 / 2) + (4 / 16)), ((-1 / 2) + (2 / 16)), ((1 / 2) - (5 / 16)), ((1 / 2) - (4 / 16)), ((-1 / 2) + (4 / 16))}, {((-1 / 2) + (5 / 16)), ((-1 / 2) + (4 / 16)), ((1 / 2) - (4 / 16)), ((1 / 2) - (5 / 16)), ((1 / 2) - (4 / 16)), ((1 / 2) - (2 / 16))}, {((-1 / 2) + (4 / 16)), ((-1 / 2) + (5 / 16)), ((-1 / 2) + (1 / 16)), ((1 / 2) - (4 / 16)), ((1 / 2) - (5 / 16)), ((-1 / 2) + (5 / 16))}, {((-1 / 2) + (4 / 16)), ((-1 / 2) + (5 / 16)), ((1 / 2) - (5 / 16)), ((1 / 2) - (4 / 16)), ((1 / 2) - (5 / 16)), ((1 / 2) - (1 / 16))}}, type = "fixed"}
local function setup_transformer_formspec(pos)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  inv:set_size("primary", 1)
  inv:set_size("secondary", 1)
  return meta:set_string("formspec", ("size[8,6.5]" .. "label[2,0;Primary winding]" .. "list[context;primary;2,0.5;1,1;]" .. "label[5,0;Secondary winding]" .. "list[context;secondary;5,0.5;1,1;]" .. "list[current_player;main;0,2;8,1;]" .. "list[current_player;main;0,3.5;8,3;8]"))
end
local function _0_(pos, from_list, from_index, to_list, to_index, count, player)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  local stack = inv:get_stack(from_list, from_index)
  if ((to_list == "primary") or (to_list == "secondary")) then
    if (minetest.get_item_group(stack:get_name(), "cable") > 0) then
      return stack:get_count()
    else
      return 0
    end
  else
    return stack:get_count()
  end
end
local function _1_(pos, listname, index, stack, player)
  if (minetest.get_item_group(stack:get_name(), "cable") > 0) then
    return stack:get_count()
  else
    return 0
  end
end
local function _2_(pos)
  setup_transformer_formspec(pos)
  return set_resis(transformer_resis)(pos)
end
minetest.register_node("electricity:transformer", {allow_metadata_inventory_move = _0_, allow_metadata_inventory_put = _1_, description = "Transformer", drawtype = "nodebox", groups = {conductor = 1, crumbly = 3}, node_box = transformer_box, on_construct = _2_, on_destruct = andthen(reset_current, drop_everything), paramtype = "light", selection_box = transformer_box, tiles = {"electricity_transformer_top.png", "electricity_transformer.png", "electricity_transformer_side_primary.png", "electricity_transformer_side_secondary.png", "electricity_transformer_front_primary.png", "electricity_transformer_front_secondary.png"}})
local function cable_3f(name)
  return (minetest.get_item_group(name, "cable") ~= 0)
end
local function _3_(pos, id)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  local prim_winding = inv:get_stack("primary", 1)
  local sec_winding = inv:get_stack("secondary", 1)
  local N_e2_82_81 = prim_winding:get_count()
  local N_e2_82_82 = sec_winding:get_count()
  local in_pin = vector.new(1, 0, 0)
  local out_pin = vector.new(0, 0, 1)
  local prim_e2_82_80 = vector.add(pos, in_pin)
  local prim_e2_82_81 = vector.add(pos, out_pin)
  local sec_e2_82_80 = vector.subtract(pos, in_pin)
  local sec_e2_82_81 = vector.subtract(pos, out_pin)
  local A = hash_node_connect(pos, prim_e2_82_80)
  local B = hash_node_connect(pos, prim_e2_82_81)
  local C = hash_node_connect(pos, sec_e2_82_80)
  local D = hash_node_connect(pos, sec_e2_82_81)
  local T = (id .. "-zero")
  if ((N_e2_82_81 ~= 0) and (N_e2_82_82 ~= 0) and cable_3f(prim_winding:get_name()) and cable_3f(sec_winding:get_name())) then
    if (N_e2_82_81 ~= N_e2_82_82) then
      local L_e2_82_81_e2_82_82 = math.sqrt((N_e2_82_81 * N_e2_82_82))
      local L_e2_82_81 = (N_e2_82_81 - L_e2_82_81_e2_82_82)
      local L_e2_82_82 = (N_e2_82_82 - L_e2_82_81_e2_82_82)
      return {}, {{["neg-node"] = T, ["pos-node"] = A, name = (id .. "-prim"), type = "consumer", value = inductance(L_e2_82_81)}, {["neg-node"] = C, ["pos-node"] = T, name = (id .. "-sec"), type = "consumer", value = inductance(L_e2_82_82)}, {["neg-node"] = B, ["pos-node"] = T, name = (id .. "-T"), type = "consumer", value = inductance(L_e2_82_81_e2_82_82)}, {["neg-node"] = D, ["pos-node"] = B, name = (id .. "-resis"), type = "consumer", value = real(transformer_resis)}}
    else
      return {}, {{["neg-node"] = C, ["pos-node"] = A, name = (id .. "-fst"), type = "consumer", value = real(transformer_resis)}, {["neg-node"] = D, ["pos-node"] = B, name = (id .. "-snd"), type = "consumer", value = real(transformer_resis)}}
    end
  end
end
model["electricity:transformer"] = _3_
return nil
