import("radiation", "conf")
local radiation_vect = vector.new(16, 16, 16)
local radiation_effects_timeout = 1
local function get_activity(name)
  local function _0_()
    if minetest.registered_nodes[name] then
      return activity[minetest.get_content_id(name)]
    else
      return activity[name]
    end
  end
  return (_0_() or null())
end
local function hypot_sqr(pos_e2_82_81, pos_e2_82_82)
  return (((pos_e2_82_81.x - pos_e2_82_82.x) ^ 2) + ((pos_e2_82_81.y - pos_e2_82_82.y) ^ 2) + ((pos_e2_82_81.z - pos_e2_82_82.z) ^ 2))
end
local function alpha(A, source, pos)
  return (A * math.exp(( - hypot_sqr(source, pos))))
end
local function beta(A, source, pos)
  local dist_c2_b2 = hypot_sqr(source, pos)
  if (dist_c2_b2 ~= 0) then
    return ((A * math.exp(( - math.sqrt(dist_c2_b2)))) / dist_c2_b2)
  else
    return A
  end
end
local function gamma(A, source, pos)
  local dist_c2_b2 = hypot_sqr(source, pos)
  if (dist_c2_b2 ~= 0) then
    return (A / dist_c2_b2)
  else
    return A
  end
end
local function radiation_summary(A, source, pos)
  return {alpha = alpha(A.alpha, source, pos), beta = beta(A.beta, source, pos), gamma = gamma(A.gamma, source, pos)}
end
local function add(A_e2_82_81, A_e2_82_82)
  return {alpha = (A_e2_82_81.alpha + A_e2_82_82.alpha), beta = (A_e2_82_81.beta + A_e2_82_82.beta), gamma = (A_e2_82_81.gamma + A_e2_82_82.gamma)}
end
local function mult(k, A)
  return {alpha = (k * A.alpha), beta = (k * A.beta), gamma = (k * A.gamma)}
end
local function _0_(A)
  return (A.alpha + A.beta + A.gamma)
end
total = _0_
local function calculate_inventory_radiation(inv)
  local radiation = {alpha = 0, beta = 0, gamma = 0}
  for listname, lst in pairs(inv:get_lists()) do
    if (listname ~= "creative_inv") then
      for _, stack in ipairs(lst) do
        local A = get_activity(stack:get_name())
        local stack_count = stack:get_count()
        radiation["beta"] = (radiation.beta + (A.beta * stack_count))
        radiation["gamma"] = (radiation.gamma + (A.gamma * stack_count))
      end
    end
  end
  return radiation
end
local function _1_(vm, pos)
  local radiation = null()
  local minp, maxp = vm:read_from_map(vector.subtract(pos, radiation_vect), vector.add(pos, radiation_vect))
  local area = VoxelArea:new({MaxEdge = maxp, MinEdge = minp})
  local data = vm:get_data()
  for i = 1, #data do
    local cid = data[i]
    local A = activity[cid]
    if A then
      local source = vector.add(area:position(i), vector.new(0, (-1 / 2), 0))
      radiation = add(radiation, radiation_summary(A, pos, source))
    end
    if has_inventory[cid] then
      local source = area:position(i)
      local inv = minetest.get_meta(source):get_inventory()
      local A0 = calculate_inventory_radiation(inv)
      radiation = add(radiation, radiation_summary(A0, pos, vector.add(source, vector.new(0, (-1 / 2), 0))))
    end
  end
  return radiation
end
calculate_radiation = _1_
local function calculate_player_radiation(player, vm)
  local pos = player:get_pos()
  local objs = minetest.get_objects_inside_radius(pos, vector.length(radiation_vect))
  local radiation = calculate_radiation(vm, pos)
  for _, obj in pairs(objs) do
    local name = player:get_player_name()
    local entity = obj:get_luaentity()
    if (entity and (entity.name == "__builtin:item")) then
      local stack = ItemStack(entity.itemstring)
      local A = get_activity(stack:get_name())
      radiation = add(radiation, mult(stack:get_count(), radiation_summary(A, pos, obj:get_pos())))
    end
  end
  do
    local wielded = player:get_wielded_item()
    radiation["alpha"] = (radiation.alpha + (get_activity(wielded:get_name()).alpha * wielded:get_count()))
    radiation = add(radiation, calculate_inventory_radiation(player:get_inventory()))
  end
  return radiation
end
local maximum_dose = 5
local function radiation_effects(player, radiation)
  local meta = player:get_meta()
  local dose_e2_82_80 = meta:get_float("received_dose")
  local dose = (dose_e2_82_80 + (radiation_effects_timeout * (radiation / 3600)))
  if (dose < 0) then
    dose = 0
  end
  meta:set_float("received_dose", dose)
  local dose_damage_limit = meta:get_float("dose_damage_limit")
  if (dose > dose_damage_limit) then
    local inv = player:get_inventory()
    local drug_stack = inv:get_list("antiradiation")[1]
    local drug_value = antiradiation_drugs[drug_stack:get_name()]
    if (drug_value and (dose <= maximum_dose)) then
      meta:set_float("dose_damage_limit", (dose_damage_limit + drug_value))
      drug_stack:set_count((drug_stack:get_count() - 1))
      return inv:set_stack("antiradiation", 1, drug_stack)
    else
      return player:set_hp((player:get_hp() - math.floor(dose)))
    end
  end
end
local radiation_timer = 0
local function _2_(_ce_94t)
  radiation_timer = (radiation_timer + _ce_94t)
  local vm = minetest.get_voxel_manip()
  for _, player in ipairs(minetest.get_connected_players()) do
    local meta = player:get_meta()
    local radiation_e2_82_80 = meta:get_float("radiation")
    local radiation = total(calculate_player_radiation(player, vm))
    local radiation_e2_80_b2 = ((radiation_e2_82_80 + radiation) / 2)
    meta:set_float("radiation", radiation_e2_80_b2)
    if (radiation_timer > radiation_effects_timeout) then
      radiation_effects(player, radiation)
    end
  end
  if (radiation_timer > radiation_effects_timeout) then
    radiation_timer = 0
    return nil
  end
end
return minetest.register_globalstep(_2_)
