local function _0_(pos)
  return string.format("%f,%f,%f", pos.x, pos.y, pos.z)
end
serialize_pos = _0_
local function _1_(str)
  local x, y, z = str:match("([^,]+),([^,]+),([^,]+)")
  return vector.new(tonumber(x), tonumber(y), tonumber(z))
end
deserialize_pos = _1_
local function drop_current(pos)
  local meta = minetest.get_meta(pos)
  meta:set_float("I", 0)
  meta:set_float("\207\134\225\181\162", 0)
  meta:set_float("U", 0)
  return meta:set_float("\207\134\225\181\164", 0)
end
local function _2_(current, already_processed)
  for _, vect in ipairs(neighbors) do
    local pos = vector.add(current, vect)
    local name = minetest.get_node(pos).name
    if (((minetest.get_item_group(name, "conductor") > 0) or (minetest.get_item_group(name, "cable") > 0)) and not already_processed[serialize_pos(pos)]) then
      local meta = minetest.get_meta(pos)
      meta:set_float("I", 0)
      meta:set_float("U", 0)
      already_processed[serialize_pos(pos)] = true
      if consumers[name] then
        minetest.get_node_timer(pos):start(0.5)
      end
      reset_circuits(pos, already_processed)
    end
  end
  return nil
end
reset_circuits = _2_
local function measurement_delta(X)
  if (X == 0) then
    return 0
  else
    return (X + (math.random() / 2))
  end
end
local function _3_(meta, consumer)
  local I = math.abs(meta:get_float("I"))
  local U = math.abs(meta:get_float("U"))
  local _cf_86_e1_b5_a2 = meta:get_float("\207\134\225\181\162")
  local _cf_86_e1_b5_a4 = meta:get_float("\207\134\225\181\164")
  local _cf_86 = (_cf_86_e1_b5_a4 - _cf_86_e1_b5_a2)
  local P = (0.5 * I * U * math.cos(_cf_86))
  return (P >= consumer["P\226\130\152\225\181\162\226\130\153"])
end
check_current = _3_
local function check_consumer(meta, consumer)
  local active_3f = (meta:get_int("active") == 1)
  local current_ok_3f = check_current(meta, consumer)
  local I = math.abs(meta:get_float("I"))
  return {activate = (not active_3f and current_ok_3f and consumer.on_activate), burn = (I > consumer["I\226\130\152\226\130\144\226\130\147"]), deactivate = (active_3f and not current_ok_3f and consumer.on_deactivate)}
end
local function get_float_by_pos(key)
  local function _4_(pos)
    return minetest.get_meta(pos):get_float(key)
  end
  return _4_
end
local get_emf = get_float_by_pos("emf")
local get_resis = get_float_by_pos("resis")
local idx = 0
local function get_name()
  idx = (idx + 1)
  return idx
end
local function is_conductor(name)
  return (minetest.get_item_group(name, "conductor") ~= 0)
end
local function is_source(name)
  return (minetest.get_item_group(name, "source") ~= 0)
end
local function find_circuits(pos, descriptions, connections, processed_sources)
  local res = {}
  local queue = {pos}
  for _, current in ipairs(queue) do
    for _0, vect in ipairs(neighbors) do
      local pos0 = vector.add(current, vect)
      local name = minetest.get_node(pos0).name
      local str = serialize_pos(pos0)
      if (not descriptions[str] and not processed_sources[str] and (is_conductor(name) or is_source(name))) then
        local connection, desc = model[name](pos0, get_name())
        descriptions[str] = desc
        connections[str] = connection
        if is_source(name) then
          processed_sources[str] = true
        end
        if consumers[name] then
          minetest.get_node_timer(pos0):start(0.5)
        end
        drop_current(pos0)
        table.insert(queue, pos0)
      end
    end
  end
  return nil
end
local function set_float(meta, name, value)
  if (value ~= value) then
    return meta:set_float(name, 0)
  else
    return meta:set_float(name, (value or 0))
  end
end
local function calculate_device(info, elapsed)
  local meta = minetest.get_meta(info.pos)
  local name = minetest.get_node(info.pos).name
  local consumer_e2_80_b2 = consumers[name]
  set_float(meta, "I", info.I)
  set_float(meta, "\207\134\225\181\162", info["\207\134\225\181\162"])
  set_float(meta, "U", info.U)
  set_float(meta, "\207\134\225\181\164", info["\207\134\225\181\164"])
  if consumer_e2_80_b2 then
    local actions = check_consumer(meta, consumer_e2_80_b2)
    if actions.activate then
      consumer_e2_80_b2.on_activate(info.pos)
      meta:set_int("active", 1)
    elseif actions.deactivate then
      consumer_e2_80_b2.on_deactivate(info.pos)
      meta:set_int("active", 0)
    elseif actions.burn then
      drop_current(info.pos)
      consumer_e2_80_b2.burn(info.pos)
    end
  end
  local _5_0 = on_circuit_tick[name]
  if _5_0 then
    return funcall(_5_0, meta, elapsed)
  else
    return _5_0
  end
end
local function get_time()
  return (minetest.get_timeofday() * 60 * 60 * 24)
end
local function process_source(pos, processed_sources, elapsed)
  local descriptions = {}
  local connections = {}
  local circ = {}
  local str = serialize_pos(pos)
  local func = model[minetest.get_node(pos).name]
  if func then
    local connection, desc = func(pos, get_name())
    descriptions[str] = desc
    connections[str] = connection
    drop_current(pos)
    processed_sources[str] = true
    find_circuits(pos, descriptions, connections, processed_sources)
    local function _4_(...)
      return append(circ, ...)
    end
    foreach(_4_, descriptions)
    local res = circsolve(circ)
    for str0, connection0 in pairs(connections) do
      local pos0 = deserialize_pos(str0)
      local info = {pos = pos0}
      if connection0.current then
        local I = (res.currents[connection0.current] or real(0))
        info["I"] = complex.abs(I)
        info["\207\134\225\181\162"] = complex.arg(I)
      end
      if (connection0.pos and connection0.neg) then
        local U_e2_82_81 = (res.voltages[connection0.pos] or real(0))
        local U_e2_82_82 = (res.voltages[connection0.neg] or real(0))
        local U = (U_e2_82_81 - U_e2_82_82)
        info["U"] = complex.abs(U)
        info["\207\134\225\181\164"] = complex.arg(U)
      end
      calculate_device(info, elapsed)
    end
    return nil
  end
end
local function globalstep(_ce_94t)
  local processed_sources = {}
  for str, t in pairs(sources) do
    if (_ce_94t >= t) then
      sources[str] = nil
    else
      sources[str] = (t - _ce_94t)
      if not processed_sources[str] then
        process_source(deserialize_pos(str), processed_sources, _ce_94t)
      end
    end
  end
  idx = 0
  return nil
end
sources = {}
local function _4_(pos)
  sources[serialize_pos(pos)] = 1
  return nil
end
minetest.register_abm({action = _4_, chance = 1, interval = 1, label = "Enable electrcity sources", nodenames = {"group:source"}})
local electricity_step = 0.5
local timer = 0
local function _5_(_ce_94t)
  timer = (timer + _ce_94t)
  if (timer >= electricity_step) then
    globalstep(timer)
    timer = 0
    return nil
  end
end
return minetest.register_globalstep(_5_)
