local function health(player)
  return ("Health: " .. player:get_hp())
end
local function space_suit(player)
  local meta = player:get_meta()
  return ("Space suit: " .. meta:get_int("space_suit"))
end
local function gas(player)
  local pos = player:get_pos()
  local name = (get_gas(above(pos)) or get_gas(pos) or "argon")
  return ("Gas: " .. name)
end
local function oxygen(player)
  local meta = player:get_meta()
  return ("Oxygen: " .. meta:get_int("oxygen") .. "/" .. meta:get_int("oxygen_max"))
end
local function gravity(player)
  local gravity0 = (player:get_physics_override().gravity * 100)
  return string.format("Gravity: %.4f %%", gravity0)
end
local function radiation(player)
  local meta = player:get_meta()
  return (string.format("Radiation: %.3f CU/h", meta:get_float("radiation")) .. "\n" .. string.format("Received dose: %.3f mCU", (meta:get_float("received_dose") * 1000)))
end
local function copyright(player)
  return join("\n", "", "Just Another Space Suit v15.0", "\194\169 2073\226\128\1482081 Skolkovo")
end
local hud_elems = {health, space_suit, gas, oxygen, gravity, radiation, copyright}
local function _0_(_)
  for _0, player in ipairs(minetest.get_connected_players()) do
    local text = ""
    for _1, func in ipairs(hud_elems) do
      text = (text .. "\n" .. func(player))
    end
    local hud = oxygen_hud[player:get_player_name()]
    player:hud_change(hud, "text", text)
  end
  return nil
end
return minetest.register_globalstep(_0_)
