for name, params in pairs(ores) do
  local light_source = (params.light_source or 0)
  for _, place in ipairs(params.wherein) do
    minetest.register_node(("loria:" .. name .. "_" .. place), {description = (capitalization(name) .. " (in " .. place .. ")"), groups = {cracky = 2}, light_source = math.floor((light_source / 2)), tiles = {("loria_" .. place .. ".png^loria_" .. name .. "_ore.png")}})
  end
  if contains(params.wherein, "cobalt_blue") then
    minetest.register_alias(("loria:" .. name .. "_azure"), ("loria:" .. name .. "_cobalt_blue"))
  end
  minetest.register_node(("loria:" .. name), {description = (capitalization(name) .. " (" .. params.formula .. ")"), drop = ("loria:" .. name), groups = {cracky = 1}, light_source = light_source, tiles = {("loria_" .. name .. ".png")}})
  if params.has_ingot then
    minetest.register_craftitem(("loria:" .. name .. "_ingot"), {description = (capitalization(name) .. " ingot"), inventory_image = ("loria_" .. name .. "_ingot.png")})
  end
end
minetest.register_node("loria:humus", {description = "Humus", groups = {cracky = 3}, tiles = {"loria_humus.png"}})
minetest.register_node("loria:plutonium_dioxide", {description = "Plutonium (IV) oxide (PuO2)", groups = {cracky = 2}, tiles = {"loria_plutonium_dioxide.png"}})
minetest.register_node("loria:plutonium_tetrafluoride", {description = "Plutonium (IV) tetrafluoride (PuF4)", groups = {cracky = 2}, tiles = {"loria_plutonium_tetrafluoride.png"}})
minetest.register_node("loria:plutonium_hexafluoride", {description = "Plutonium (VI) hexafluoride (PuF6)", groups = {cracky = 2}, tiles = {"loria_plutonium_hexafluoride.png"}})
liquid_ores = {hydrochloric_acid = {liquid = "loria:hydrochloric_acid_source", y_max = 50, y_min = -150}, trisilane = {liquid = "loria:trisilane_source"}}
for name, params in pairs(liquid_ores) do
  local function _0_(pos, oldnode)
    return minetest.set_node(pos, {name = params.liquid})
  end
  minetest.register_node(("loria:" .. name .. "_cinnabar"), {after_destruct = _0_, description = (capitalization(name) .. " (in cinnabar)"), drop = {}, groups = {cracky = 1}, tiles = {("loria_cinnabar.png^loria_" .. name .. "_ore.png")}})
  local function _1_(pos, oldnode)
    assert((nil ~= oldnode), ("Missing argument %s on %s:%s"):format("oldnode", "sources/mods/loria/ores.fnl", 68))
    assert((nil ~= pos), ("Missing argument %s on %s:%s"):format("pos", "sources/mods/loria/ores.fnl", 68))
    return minetest.set_node(pos, {name = params.liquid})
  end
  minetest.register_node(("loria:" .. name .. "_cobalt_blue"), {after_destruct = _1_, description = (capitalization(name) .. " (in cobalt blue)"), drop = {}, groups = {cracky = 1}, tiles = {("loria_cobalt_blue.png^loria_" .. name .. "_ore.png")}})
  minetest.register_ore({clust_num_ores = 8, clust_scarcity = (8 * 8 * 8), clust_size = 3, ore = ("loria:" .. name .. "_cinnabar"), ore_type = "scatter", wherein = "loria:cinnabar", y_max = (params.y_max or 80), y_min = (params.y_min or -10)})
  minetest.register_ore({clust_num_ores = 8, clust_scarcity = (8 * 8 * 8), clust_size = 3, ore = ("loria:" .. name .. "_cobalt_blue"), ore_type = "scatter", wherein = "loria:cobalt_blue", y_max = (params.y_max or 80), y_min = (params.y_min or -10)})
end
minetest.register_ore({clust_num_ores = 8, clust_scarcity = (8 * 8 * 8), clust_size = 7, ore = "loria:sulfur", ore_type = "scatter", wherein = "loria:chromium_fluoride", y_max = 120, y_min = -200})
local selenium_spawn_places = {"loria:chromium_fluoride", "loria:chromia", "loria:cobalt_blue", "loria:cinnabar"}
for _, wherein in ipairs(selenium_spawn_places) do
  minetest.register_ore({clust_num_ores = 6, clust_scarcity = (8 * 8 * 8), clust_size = 8, ore = "loria:selenium", ore_type = "scatter", wherein = wherein, y_max = 0, y_min = -500})
end
return nil
