local cable = {}
cable.top = {(-1 / 16), (-1 / 2), (-1 / 16), (1 / 16), (1 / 2), (1 / 16)}
cable.core = {(-1 / 16), (-1 / 2), (-1 / 16), (1 / 16), ((-1 / 2) + (1 / 16)), (1 / 16)}
cable.front = {(-1 / 16), (-1 / 2), (-1 / 2), (1 / 16), ((-1 / 2) + (1 / 16)), (1 / 16)}
cable.back = {(-1 / 16), (-1 / 2), (-1 / 16), (1 / 16), ((-1 / 2) + (1 / 16)), (1 / 2)}
cable.left = {(-1 / 2), (-1 / 2), (-1 / 16), (1 / 16), ((-1 / 2) + (1 / 16)), (1 / 16)}
cable.right = {(-1 / 16), (-1 / 2), (-1 / 16), (1 / 2), ((-1 / 2) + (1 / 16)), (1 / 16)}
local cable_box = {connect_back = cable.back, connect_bottom = cable.core, connect_front = cable.front, connect_left = cable.left, connect_right = cable.right, connect_top = cable.top, fixed = cable.core, type = "connected"}
local cable_overlap_box = {fixed = {cable.left, cable.right, {(-1 / 16), (-1 / 2), (-1 / 2), (1 / 16), ((-1 / 2) + (1 / 16)), (-4 / 16)}, {(1 / 16), (-1 / 2), (1 / 2), (-1 / 16), ((-1 / 2) + (1 / 16)), (4 / 16)}, {(1 / 16), (-1 / 16), (-4 / 16), (-1 / 16), 0, (4 / 16)}, {(-1 / 16), (-1 / 2), (-3 / 16), (1 / 16), 0, (-4 / 16)}, {(1 / 16), (-1 / 2), (3 / 16), (-1 / 16), 0, (4 / 16)}}, type = "fixed"}
local function cable_model(conf)
  local function _0_(pos, id)
    local center = hash_node_pos(pos)
    local res = {}
    for idx, vect in ipairs(neighbors) do
      table.insert(res, {["neg-node"] = hash_node_connect(pos, vector.add(pos, vect)), ["pos-node"] = center, name = (id .. "-" .. idx), type = "consumer", value = conf.resis})
    end
    return {}, res
  end
  return _0_
end
local function cable_overlap_model(conf)
  local function _0_(pos, id)
    local conn = twoport(pos)
    return {}, {{["neg-node"] = conn["sec\226\130\129"], ["pos-node"] = conn["prim\226\130\129"], name = (id .. "-fst"), type = "consumer", value = conf.resis}, {["neg-node"] = conn["sec\226\130\130"], ["pos-node"] = conn["prim\226\130\130"], name = (id .. "-snd"), type = "consumer", value = conf.resis}}
  end
  return _0_
end
local function register_cable(conf)
  local tiles = nil
  local function _0_(...)
    return ("electricity_" .. conf.name .. ...)
  end
  tiles = map(_0_, {"_cable.png", "_cable.png", "_cable_side.png", "_cable_side.png", "_cable_side.png", "_cable_side.png"})
  local inv_image = ("electricity_" .. conf.name .. "_cable_item.png")
  minetest.register_node(("electricity:" .. conf.name .. "_cable"), {connects_to = {"group:source", "group:conductor", "group:disabled_electric_tool"}, description = (capitalization(conf.name) .. " cable"), drawtype = "nodebox", groups = {cable = 1, conductor = 1, crumbly = 3, dig_immediate = 3}, inventory_image = inv_image, is_ground_content = false, node_box = cable_box, on_destruct = reset_current, paramtype = "light", selection_box = cable_box, sunlight_propagates = true, tiles = tiles, wield_image = inv_image})
  minetest.register_node(("electricity:" .. conf.name .. "_cable_overlap"), {description = (capitalization(conf.name) .. " cable (overlap)"), drawtype = "nodebox", groups = {cable = 1, conductor = 1, crumbly = 3, dig_immediate = 3}, is_ground_content = false, node_box = cable_overlap_box, on_destruct = reset_current, paramtype = "light", selection_box = cable_overlap_box, sunlight_propagates = true, tiles = tiles})
  model[("electricity:" .. conf.name .. "_cable")] = cable_model(conf)
  model[("electricity:" .. conf.name .. "_cable_overlap")] = cable_overlap_model(conf)
  return nil
end
return foreach(register_cable, cables)
