local multimeter_box = {fixed = {{(-1 / 2), (-1 / 2), (-1 / 2), (1 / 2), ((-1 / 2) + (1 / 16)), (1 / 2)}, {(-4 / 16), ((-1 / 2) + (1 / 16)), ((-1 / 2) + (2 / 16)), (4 / 16), ((1 / 2) - (2 / 16)), ((1 / 2) - (2 / 16))}}, type = "fixed"}
local multimeter_resis = {max = 1500, min = 0.014999999999999999}
local k = 10
local function multimeter_resis_step(R)
  local r = (k * R)
  if (r > multimeter_resis.max) then
    return multimeter_resis.min
  else
    return r
  end
end
local function update_infotext(meta)
  local I = meta:get_float("I")
  local U = meta:get_float("U")
  local R = meta:get_float("resis")
  return meta:set_string("infotext", string.format("I = %.1f A\nU = %.1f V\nR = %.3f Ohms", I, U, R))
end
local function _0_(pos, node, clicker, itemstack, pointed_thing)
  local meta = minetest.get_meta(pos)
  meta:set_float("resis", multimeter_resis_step(meta:get_float("resis")))
  return update_infotext(meta)
end
minetest.register_node("electricity:multimeter", {description = "Multimeter", drawtype = "nodebox", drop = "electricity:multimeter", groups = {conductor = 1, dig_immediate = 3}, node_box = multimeter_box, on_construct = andthen(set_resis(multimeter_resis.min), comp(update_infotext, minetest.get_meta)), on_destruct = reset_current, on_rightclick = _0_, paramtype = "light", paramtype2 = "facedir", selection_box = multimeter_box, tiles = {"electricity_multimeter_top.png", "electricity_multimeter_bottom.png", "electricity_multimeter_front.png", "electricity_multimeter_back.png", "electricity_multimeter_side.png", "electricity_multimeter_side.png"}})
model["electricity:multimeter"] = vconsumer
on_circuit_tick["electricity:multimeter"] = update_infotext
local function _1_(itemstack, user, pointed_thing)
  if (pointed_thing.type == "node") then
    local meta = minetest.get_meta(pointed_thing.under)
    local I = meta:get_float("I")
    local _cf_86_e1_b5_a2 = math.deg(meta:get_float("\207\134\225\181\162"))
    local U = meta:get_float("U")
    local _cf_86_e1_b5_a4 = math.deg(meta:get_float("\207\134\225\181\164"))
    return minetest.chat_send_player(user:get_player_name(), string.format("I = %f A, \207\134\225\181\162 = %f\194\176, U = %f V, \207\134\225\181\164 = %f\194\176", I, _cf_86_e1_b5_a2, U, _cf_86_e1_b5_a4))
  end
end
return minetest.register_craftitem("electricity:multimeter_debug", {description = "Multimeter (debug tool)", inventory_image = "electricity_multimeter.png", liquids_pointable = true, on_use = _1_, stack_max = 1})
