local photoresistor_box = {fixed = {{(-1 / 2), (-1 / 2), (-1 / 2), (1 / 2), 0, (1 / 2)}}, type = "fixed"}
local function log(b, x)
  return (math.log(x) / math.log(b))
end
local R_e2_82_98_e1_b5_a2_e2_82_99 = 0.01
local R_e2_82_98_e2_82_90_e2_82_93 = (10 ^ 6)
local _ce_b3 = log(16, (R_e2_82_98_e1_b5_a2_e2_82_99 / R_e2_82_98_e2_82_90_e2_82_93))
local R = R_e2_82_98_e2_82_90_e2_82_93
local function photoresistor_resis(L)
  return (R * ((L + 1) ^ _ce_b3))
end
minetest.register_node("electricity:photoresistor", {description = "Photoresistor", drawtype = "nodebox", groups = {conductor = 1, crumbly = 3}, node_box = photoresistor_box, on_construct = set_resis(1, 0), on_destruct = reset_current, paramtype = "light", paramtype2 = "facedir", selection_box = photoresistor_box, tiles = {"electricity_photoresistor_top.png", "electricity_photoresistor_bottom.png", "electricity_photoresistor_side.png", "electricity_photoresistor_side.png", "electricity_photoresistor_connect_side.png", "electricity_photoresistor_connect_side.png"}})
local function _0_(pos, id)
  local L = (minetest.get_node_light(pos) or 0)
  local R0 = photoresistor_resis(L)
  return twopole("consumer", id, pos, R0)
end
model["electricity:photoresistor"] = _0_
return nil
