local transformer_resis = 0.0001
local transformer_box = {fixed = {{(-1 / 2), (-1 / 2), (-1 / 2), (1 / 2), ((-1 / 2) + (2 / 16)), (1 / 2)}, {((-1 / 2) + (5 / 16)), ((-1 / 2) + (2 / 16)), ((-1 / 2) + (2 / 16)), ((1 / 2) - (5 / 16)), ((-1 / 2) + (4 / 16)), ((1 / 2) - (2 / 16))}, {((-1 / 2) + (5 / 16)), ((1 / 2) - (4 / 16)), ((-1 / 2) + (2 / 16)), ((1 / 2) - (5 / 16)), ((1 / 2) - (2 / 16)), ((1 / 2) - (2 / 16))}, {((-1 / 2) + (5 / 16)), ((-1 / 2) + (4 / 16)), ((-1 / 2) + (2 / 16)), ((1 / 2) - (5 / 16)), ((1 / 2) - (4 / 16)), ((-1 / 2) + (4 / 16))}, {((-1 / 2) + (5 / 16)), ((-1 / 2) + (4 / 16)), ((1 / 2) - (4 / 16)), ((1 / 2) - (5 / 16)), ((1 / 2) - (4 / 16)), ((1 / 2) - (2 / 16))}, {((-1 / 2) + (4 / 16)), ((-1 / 2) + (5 / 16)), ((-1 / 2) + (1 / 16)), ((1 / 2) - (4 / 16)), ((1 / 2) - (5 / 16)), ((-1 / 2) + (5 / 16))}, {((-1 / 2) + (4 / 16)), ((-1 / 2) + (5 / 16)), ((1 / 2) - (5 / 16)), ((1 / 2) - (4 / 16)), ((1 / 2) - (5 / 16)), ((1 / 2) - (1 / 16))}}, type = "fixed"}
local function setup_transformer_formspec(pos)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  inv:set_size("primary", 1)
  inv:set_size("secondary", 1)
  return meta:set_string("formspec", ("size[8,6.5]" .. "label[2,0;Primary winding]" .. "list[context;primary;2,0.5;1,1;]" .. "label[5,0;Secondary winding]" .. "list[context;secondary;5,0.5;1,1;]" .. "list[current_player;main;0,2;8,1;]" .. "list[current_player;main;0,3.5;8,3;8]"))
end
local function wire_3f(name)
  return (minetest.get_item_group(name, "wire") ~= 0)
end
local function _0_(pos, from_list, from_index, to_list, to_index, count, player)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  local stack = inv:get_stack(from_list, from_index)
  if ((to_list == "primary") or (to_list == "secondary")) then
    if wire_3f(stack:get_name()) then
      return stack:get_count()
    else
      return 0
    end
  else
    return stack:get_count()
  end
end
local function _1_(pos, listname, index, stack, player)
  if wire_3f(stack:get_name()) then
    return stack:get_count()
  else
    return 0
  end
end
local function _2_(pos)
  setup_transformer_formspec(pos)
  return set_resis(transformer_resis)(pos)
end
minetest.register_node("electricity:transformer", {allow_metadata_inventory_move = _0_, allow_metadata_inventory_put = _1_, description = "Transformer", drawtype = "nodebox", groups = {conductor = 1, crumbly = 3}, node_box = transformer_box, on_construct = _2_, on_destruct = andthen(reset_current, drop_everything), paramtype = "light", selection_box = transformer_box, tiles = {"electricity_transformer_top.png", "electricity_transformer.png", "electricity_transformer_side_primary.png", "electricity_transformer_side_secondary.png", "electricity_transformer_front_primary.png", "electricity_transformer_front_secondary.png"}})
local function _3_(pos, id)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  local prim_winding = inv:get_stack("primary", 1)
  local sec_winding = inv:get_stack("secondary", 1)
  local N_e2_82_81 = prim_winding:get_count()
  local N_e2_82_82 = sec_winding:get_count()
  local conn = twoport(pos)
  local T = (id .. "-zero")
  if ((N_e2_82_81 ~= 0) and (N_e2_82_82 ~= 0) and wire_3f(prim_winding:get_name()) and wire_3f(sec_winding:get_name())) then
    if (N_e2_82_81 ~= N_e2_82_82) then
      local L_e2_82_81_e2_82_82 = math.sqrt((N_e2_82_81 * N_e2_82_82))
      local L_e2_82_81 = (N_e2_82_81 - L_e2_82_81_e2_82_82)
      local L_e2_82_82 = (N_e2_82_82 - L_e2_82_81_e2_82_82)
      return {}, {{name = (id .. "-prim"), neg = T, pos = conn["prim\226\130\129"], type = "consumer", value = inductance(L_e2_82_81)}, {name = (id .. "-sec"), neg = conn["sec\226\130\129"], pos = T, type = "consumer", value = inductance(L_e2_82_82)}, {name = (id .. "-T"), neg = conn["prim\226\130\130"], pos = T, type = "consumer", value = inductance(L_e2_82_81_e2_82_82)}, {name = (id .. "-resis"), neg = conn["sec\226\130\130"], pos = conn["prim\226\130\130"], type = "consumer", value = real(transformer_resis)}}
    else
      return {}, {{name = (id .. "-fst"), neg = conn["sec\226\130\129"], pos = conn["prim\226\130\129"], type = "consumer", value = real(transformer_resis)}, {name = (id .. "-snd"), neg = conn["sec\226\130\130"], pos = conn["prim\226\130\130"], type = "consumer", value = real(transformer_resis)}}
    end
  end
end
model["electricity:transformer"] = _3_
return nil
