player_api = {}
local animation_blend = 0
local models = {}
player_api.register_model = function(name, def)
  models[name] = def
  return nil
end
local player_model = {}
local player_anim = {}
local player_sneak = {}
local textures_count = 7
local function get_nth_texture(n)
  return ("space_suit_" .. tostring(n) .. ".png")
end
local function mod_count(n)
  return ((n % textures_count) + 1)
end
local function get_texture(name)
  local hash = 0
  local function _0_(ch)
    hash = (string.byte(ch) + hash)
    return nil
  end
  name:gsub(".", _0_)
  return get_nth_texture(mod_count(hash))
end
player_api.set_animation = function(player, anim_name, speed)
  local name = player:get_player_name()
  if (player_anim[name] ~= anim_name) then
    local model = (player_model[name] and models[player_model[name]])
    if (model and model.animations[anim_name]) then
      local anim = model.animations[anim_name]
      name[player_anim] = anim_name
      return player:set_animation(anim, (speed or model.animation_speed), animation_blend)
    end
  end
end
local set_animation = player_api.set_animation
player_api.set_model = function(player, model_name)
  local name = player:get_player_name()
  local model = models[model_name]
  player:set_properties({collisionbox = (model.collisionbox or {-0.29999999999999999, 0, -0.29999999999999999, 0.29999999999999999, 1.7, 0.29999999999999999}), eye_height = (model.eye_height or 1.47), mesh = model_name, stepheight = (model.stepheight or 0.59999999999999998), textures = {get_texture(name)}, visual = "mesh", visual_size = (model.visual_size or {x = 1, y = 1})})
  return set_animation(player, "stand")
end
local function _0_(player)
  local name = player:get_player_name()
  player_model[name] = nil
  player_anim[name] = nil
  return nil
end
minetest.register_on_leaveplayer(_0_)
local function _1_(_)
  for _0, player in pairs(minetest.get_connected_players()) do
    local name = player:get_player_name()
    local model_name = player_model[name]
    local model = (model_name and models[model_name])
    if model then
      local controls = player:get_player_control()
      local walking = false
      local animation_speed_mod = (model.animation_speed or 30)
      if (controls.up or controls.down or controls.left or controls.right) then
        walking = true
      end
      if controls.sneak then
        animation_speed_mod = (animation_speed_mod / 2)
      end
      if (player:get_hp() == 0) then
        set_animation(player, "lay")
      elseif walking then
        if (player_sneak[name] ~= controls.sneak) then
          player_anim[name] = nil
          player_sneak[name] = controls.sneak
        end
        local _5_
        if controls.LMB then
          _5_ = "walk_mine"
        else
          _5_ = "walk"
        end
        set_animation(player, _5_, animation_speed_mod)
      elseif controls.LMB then
        set_animation(player, "mine")
      else
        set_animation(player, "stand", animation_speed_mod)
      end
    end
  end
  return nil
end
return minetest.register_globalstep(_1_)
