refiner_crafts = {{input = {{count = 2, name = "loria:copper_sulfate_pure"}, {count = 3, name = "loria:empty_balloon"}}, output = {{count = 2, name = "loria:copper_oxide"}, {count = 2, name = "loria:sulfur_dioxide_balloon"}, {count = 1, name = "loria:oxygen_balloon"}}, time = 4}, {input = {{count = 2, name = "loria:cuprous_oxide"}, {count = 1, name = "loria:empty_balloon"}}, output = {{count = 4, name = "loria:copper"}, {count = 1, name = "loria:oxygen_balloon"}}, time = 2}, {input = {{count = 1, name = "loria:copper"}, {count = 1, name = "loria:copper_oxide"}}, output = {{count = 1, name = "loria:cuprous_oxide"}}, time = 4}, {input = {{count = 2, name = "loria:mercury_oxide"}, {count = 1, name = "loria:empty_balloon"}, {count = 2, name = "loria:bucket_empty"}}, output = {{count = 1, name = "loria:oxygen_balloon"}, {count = 2, name = "loria:bucket_mercury"}}, time = 3}, {input = {{count = 1, name = "loria:cinnabar"}, {count = 1, name = "loria:bucket_empty"}}, output = {{count = 1, name = "loria:sulfur"}, {count = 1, name = "loria:bucket_mercury"}}, time = 5}, {input = {{count = 2, name = "loria:red_mercury_oxide"}, {count = 1, name = "loria:empty_balloon"}, {count = 2, name = "loria:bucket_empty"}}, output = {{count = 1, name = "loria:oxygen_balloon"}, {count = 2, name = "loria:bucket_mercury"}}, time = 3}, {input = {{count = 1, name = "loria:copper_sulfate"}, {count = 5, name = "loria:bucket_empty"}}, output = {{count = 1, name = "loria:copper_sulfate_pure"}, {count = 5, name = "loria:bucket_water"}}, time = 5}, {input = {{count = 1, name = "loria:aluminium_ore"}}, output = {{count = 1, name = "loria:aluminium_ingot"}, {count = 1, name = "loria:cinnabar"}}, time = 3}, {input = {{count = 1, name = "loria:mercury_oxide"}, {count = 1, name = "loria:bucket_potassium_hydroxide"}, {count = 1, name = "loria:zinc_ingot"}, {count = 1, name = "loria:aluminium_case"}}, output = {{count = 1, name = "loria:battery"}, {count = 1, name = "loria:bucket_empty"}}, time = 2}, {input = {{count = 1, name = "loria:red_mercury_oxide"}, {count = 1, name = "loria:bucket_potassium_hydroxide"}, {count = 1, name = "loria:zinc_ingot"}, {count = 1, name = "loria:aluminium_case"}}, output = {{count = 1, name = "loria:battery"}, {count = 1, name = "loria:bucket_empty"}}, time = 2}, {input = {{count = 9, name = "loria:silicon_dioxide"}}, output = {{count = 1, name = "loria:fused_quartz"}}, time = 3}, {input = {{count = 4, name = "loria:plutonium_trifluoride"}, {count = 1, name = "loria:oxygen_balloon"}}, output = {{count = 3, name = "loria:plutonium_tetrafluoride"}, {count = 1, name = "loria:plutonium_dioxide"}, {count = 1, name = "loria:empty_balloon"}}, time = 3}, {input = {{count = 1, name = "loria:lead_sulfate"}, {count = 1, name = "loria:bucket_empty"}}, output = {{count = 1, name = "loria:lead_oxide"}, {count = 1, name = "loria:bucket_sulfur_trioxide"}}, time = 4}, {input = {{count = 1, name = "loria:lead_oxide"}, {count = 1, name = "loria:hydrogen_balloon"}, {count = 1, name = "loria:bucket_empty"}}, output = {{count = 1, name = "loria:lead"}, {count = 1, name = "loria:empty_balloon"}, {count = 1, name = "loria:bucket_water"}}, time = 2}, {input = {{count = 2, name = "loria:bucket_potassium_permanganate"}, {count = 1, name = "loria:empty_balloon"}}, output = {{count = 1, name = "loria:potassium_manganate"}, {count = 1, name = "loria:manganese_dioxide"}, {count = 1, name = "loria:oxygen_balloon"}, {count = 2, name = "loria:bucket_empty"}}, time = 2}, {input = {{count = 1, name = "loria:manganese_dioxide"}, {count = 1, name = "loria:bucket_empty"}, {count = 1, name = "loria:hydrogen_balloon"}}, output = {{count = 1, name = "loria:manganese_oxide"}, {count = 1, name = "loria:bucket_water"}, {count = 1, name = "loria:empty_balloon"}}, time = 3}, {input = {{count = 4, name = "loria:aluminium"}, {count = 1, name = "loria:oxygen_balloon"}}, output = {{count = 2, name = "loria:aluminium_oxide"}, {count = 1, name = "loria:empty_balloon"}}, time = 3}, {input = {{count = 1, name = "loria:wolfram_ingot"}}, output = {{count = 15, name = "loria:wolfram_filament"}}, time = 25}, {input = {{count = 1, name = "loria:silicon_dioxide"}, {count = 2, name = "loria:hydrogen_balloon"}, {count = 2, name = "loria:bucket_empty"}}, output = {{count = 1, name = "loria:silicon"}, {count = 2, name = "loria:bucket_water"}, {count = 2, name = "loria:empty_balloon"}}, time = 2}, {input = {{count = 1, name = "loria:silicon_dioxide"}, {count = 2, name = "loria:magnesium"}}, output = {{count = 1, name = "loria:silicon"}, {count = 2, name = "loria:magnesium_oxide"}}, time = 5}, {input = {{count = 3, name = "loria:silicon_dioxide"}, {count = 4, name = "loria:aluminium"}}, output = {{count = 3, name = "loria:silicon"}, {count = 2, name = "loria:aluminium_oxide"}}, time = 6}, {input = {{count = 1, name = "loria:thorium_iodide"}}, output = {{count = 1, name = "loria:thorium"}, {count = 2, name = "loria:iodine"}}, time = 3}, {input = {{count = 3, name = "loria:plutonium_tetrafluoride"}}, output = {{count = 2, name = "loria:plutonium_trifluoride"}, {count = 1, name = "loria:plutonium_hexafluoride"}}, time = 6}, {input = {{count = 2, name = "loria:plutonium_trifluoride"}, {count = 3, name = "loria:calcium"}}, output = {{count = 2, name = "loria:plutonium"}, {count = 3, name = "loria:calcium_fluoride"}}, time = 6}, {input = {{count = 2, name = "loria:humus"}}, output = {{count = 1, name = "loria:silicon_dioxide"}}, time = 10}, {input = {{count = 2, name = "loria:sodium_peroxide"}, {count = 1, name = "loria:empty_balloon"}}, output = {{count = 2, name = "loria:sodium_oxide"}, {count = 1, name = "loria:oxygen_balloon"}}, time = 5}, {input = {{count = 4, name = "loria:chormium_trioxide"}, {count = 3, name = "loria:empty_balloon"}}, output = {{count = 2, name = "loria:chromia"}, {count = 3, name = "loria:oxygen_balloon"}}, time = 3}, {input = {{count = 1, name = "loria:chromia"}, {count = 2, name = "loria:aluminium"}}, output = {{count = 1, name = "loria:aluminium_oxide"}, {count = 2, name = "loria:chromium"}}, time = 5}, {input = {{count = 3, name = "loria:silicon"}}, output = {{count = 5, name = "electricity:transistor"}}, time = 20}, {input = {{count = 1, name = "loria:silicon"}}, output = {{count = 5, name = "electricity:diode"}}, time = 10}, {input = {{count = 1, name = "loria:lead"}, {count = 1, name = "loria:selenium"}}, output = {{count = 1, name = "loria:lead_selenide"}}, time = 5}, {input = {{count = 1, name = "loria:thorium"}, {count = 1, name = "loria:oxygen_balloon"}}, output = {{count = 1, name = "loria:thorium_dioxide"}, {count = 1, name = "loria:empty_balloon"}}, time = 6}, {input = {{count = 2, name = "loria:magnetite"}}, output = {{count = 1, name = "loria:ferrous_oxide"}, {count = 1, name = "loria:ferric_oxide"}}, time = 3}}
furnace_crafts = {{input = {{count = 1, name = "loria:mushroom_mass"}}, output = {{count = 1, name = "loria:silicon_dioxide"}}, time = 7}, {input = {{count = 5, name = "loria:aluminium_ingot"}}, output = {{count = 1, name = "loria:bucket_empty"}}, time = 8}, {input = {{count = 4, name = "loria:zinc_ingot"}}, output = {{count = 1, name = "loria:bucket_empty"}}, time = 10}, {input = {{count = 3, name = "loria:aluminium_ingot"}}, output = {{count = 1, name = "loria:empty_balloon"}}, time = 3}, {input = {{count = 2, name = "loria:aluminium_ingot"}}, output = {{count = 1, name = "loria:aluminium_brick_mold"}}, time = 3}, {input = {{count = 1, name = "loria:aluminium_ingot"}}, output = {{count = 1, name = "loria:aluminium_case"}}, time = 3}, {input = {{count = 1, name = "loria:bucket_empty"}, {count = 1, name = "loria:mercury"}}, output = {{count = 1, name = "loria:bucket_mercury"}}, time = 5}, {input = {{count = 1, name = "loria:bucket_lucidum"}}, output = {{count = 1, name = "loria:bucket_empty"}, {count = 12, name = "loria:glow_stick"}}, time = 1}, {input = {{count = 4, name = "loria:aluminium_oxide"}, {count = 4, name = "loria:silicon_dioxide"}, {count = 1, name = "loria:bucket_water"}}, output = {{count = 4, name = "loria:brick"}, {count = 1, name = "loria:bucket_empty"}}, time = 2}, {input = {{count = 9, name = "loria:plutonium_ingot"}}, output = {{count = 1, name = "loria:plutonium"}}, time = 4}, {input = {{count = 1, name = "loria:plutonium"}}, output = {{count = 9, name = "loria:plutonium_ingot"}}, time = 4}}
high_temperature_crafts = {{input = {{count = 1, name = "loria:uranium"}}, output = {{count = 9, name = "loria:uranium_ingot"}}, time = 4}, {input = {{count = 9, name = "loria:uranium_ingot"}}, output = {{count = 1, name = "loria:uranium"}}, time = 4}, {input = {{count = 9, name = "loria:thorium_ingot"}}, output = {{count = 1, name = "loria:thorium"}}, time = 4}, {input = {{count = 1, name = "loria:thorium"}}, output = {{count = 9, name = "loria:thorium_ingot"}}, time = 4}, {input = {{count = 3, name = "loria:copper_ingot"}}, output = {{count = 1, name = "loria:copper_hammer_head"}}, time = 3}}
for name, params in opairs(ores) do
  local ingot_or_node = nil
  if params.has_ingot then
    ingot_or_node = {count = 1, name = ("loria:" .. name .. "_ingot")}
  else
    ingot_or_node = {count = 1, name = ("loria:" .. name)}
  end
  for _, place in ipairs(params.wherein) do
    table.insert(refiner_crafts, {input = {{count = 1, name = ("loria:" .. name .. "_" .. place)}}, output = {ingot_or_node, {count = 1, name = ("loria:" .. place)}}, time = 3})
  end
  if params.has_ingot then
    table.insert(refiner_crafts, {input = {{count = 9, name = ("loria:" .. name .. "_ingot")}}, output = {{count = 1, name = ("loria:" .. name)}}, time = 4})
    table.insert(refiner_crafts, {input = {{count = 1, name = ("loria:" .. name)}}, output = {{count = 9, name = ("loria:" .. name .. "_ingot")}}, time = 4})
  end
end
for _, mushroom in ipairs(giant_mushrooms) do
  if (mushroom ~= "timor") then
    table.insert(furnace_crafts, {input = {{count = 3, name = ("loria:" .. mushroom .. "_body")}}, output = {{count = 1, name = "loria:silicon_dioxide"}}, time = 5})
  else
    for _0, name in ipairs(timor["body-nodes"]) do
      table.insert(furnace_crafts, {input = {{count = 3, name = name}}, output = {{count = 1, name = "loria:silicon_dioxide"}}, time = 5})
    end
  end
  table.insert(furnace_crafts, {input = {{count = 5, name = ("loria:" .. mushroom .. "_stem")}}, output = {{count = 1, name = "loria:silicon_dioxide"}}, time = 8})
end
for name, params in opairs(brickable) do
  if not params.crumbly then
    local target_list = nil
    if params.refractory then
      target_list = high_temperature_crafts
    else
      target_list = furnace_crafts
    end
    table.insert(target_list, {input = {{count = 1, name = name}}, output = {{count = 2, name = (name .. "_brick")}}, time = 3})
  end
end
fuel_list = {["loria:bucket_trisilane"] = 20, ["loria:cinnabar"] = 1, ["loria:potassium"] = 2, ["loria:potassium_azure"] = 4, ["loria:potassium_chromia"] = 5, ["loria:potassium_chromium_fluoride"] = 5, ["loria:potassium_cinnabar"] = 3, ["loria:potassium_cobalt_blue"] = 3, ["loria:potassium_ingot"] = 5}
high_temperature_furnace_crafts = {}
append(high_temperature_furnace_crafts, furnace_crafts)
return append(high_temperature_furnace_crafts, high_temperature_crafts)
