ground = "gnd"
local function calculate_consumer(A, b, elem, g2_index)
  local G = (1 / elem.value)
  if (elem.pos ~= 0) then
    A:set(elem.pos, elem.pos, (A:get(elem.pos, elem.pos) + G))
  end
  if (elem.neg ~= 0) then
    A:set(elem.neg, elem.neg, (A:get(elem.neg, elem.neg) + G))
  end
  if ((elem.pos ~= 0) and (elem.neg ~= 0)) then
    A:set(elem.pos, elem.neg, (A:get(elem.pos, elem.neg) - G))
    return A:set(elem.neg, elem.pos, (A:get(elem.neg, elem.pos) - G))
  end
end
local function calculate_voltage(A, b, elem, g2_index)
  if (elem.pos ~= 0) then
    A:set(elem.pos, g2_index, (A:get(elem.pos, g2_index) + 1))
    A:set(g2_index, elem.pos, (A:get(g2_index, elem.pos) + 1))
  end
  if (elem.neg ~= 0) then
    A:set(elem.neg, g2_index, (A:get(elem.neg, g2_index) - 1))
    A:set(g2_index, elem.neg, (A:get(g2_index, elem.neg) - 1))
  end
  return b:set(g2_index, 1, elem.value)
end
local function calculate_current(A, b, elem, g2_index)
  if (elem.pos ~= 0) then
    b:set(elem.pos, 1, (b:get(elem.pos, 1) - elem.value))
  end
  if (elem.neg ~= 0) then
    return b:set(elem.neg, 1, (b:get(elem.neg, 1) + elem.value))
  end
end
local function calculate_transformer(A, b, elem, g2_index)
  local T = elem.value
  if (elem["prim-pos"] ~= 0) then
    A:set(g2_index, elem["prim-pos"], (A:get(g2_index, elem["prim-pos"]) + T))
    A:set(elem["prim-pos"], g2_index, (A:get(elem["prim-pos"], g2_index) - T))
  end
  if (elem["prim-neg"] ~= 0) then
    A:set(g2_index, elem["prim-neg"], (A:get(g2_index, elem["prim-neg"]) - T))
    A:set(elem["prim-neg"], g2_index, (A:get(elem["prim-neg"], g2_index) + T))
  end
  if (elem["sec-pos"] ~= 0) then
    A:set(g2_index, elem["sec-pos"], (A:get(g2_index, elem["sec-pos"]) - 1))
    A:set(elem["sec-pos"], g2_index, (A:get(elem["sec-pos"], g2_index) + 1))
  end
  if (elem["sec-neg"] ~= 0) then
    A:set(g2_index, elem["sec-neg"], (A:get(g2_index, elem["sec-neg"]) + 1))
    return A:set(elem["sec-neg"], g2_index, (A:get(elem["sec-neg"], g2_index) - 1))
  end
end
local function calculate_VCVS(A, b, elem, g2_index)
  local G = elem.value
  if (elem["prim-pos"] ~= 0) then
    A:set(g2_index, elem["prim-pos"], (A:get(g2_index, elem["prim-pos"]) + G))
  end
  if (elem["prim-neg"] ~= 0) then
    A:set(g2_index, elem["prim-neg"], (A:get(g2_index, elem["prim-neg"]) - G))
  end
  if (elem["sec-pos"] ~= 0) then
    A:set(g2_index, elem["sec-pos"], (A:get(g2_index, elem["sec-pos"]) - 1))
    A:set(elem["sec-pos"], g2_index, (A:get(elem["sec-pos"], g2_index) - 1))
  end
  if (elem["sec-neg"] ~= 0) then
    A:set(g2_index, elem["sec-neg"], (A:get(g2_index, elem["sec-neg"]) - 1))
    return A:set(elem["sec-neg"], g2_index, (A:get(elem["sec-neg"], g2_index) - 1))
  end
end
local one_port = {"pos", "neg"}
local circuit_models = {VCVS = {["needs-current?"] = false, ["voltage-index"] = 1, handler = calculate_VCVS, ports = {"prim-pos", "prim-neg", "sec-pos", "sec-neg"}}, consumer = {["needs-current?"] = false, ["voltage-index"] = 0, handler = calculate_consumer, ports = one_port}, current = {["needs-current?"] = false, ["voltage-index"] = 0, handler = calculate_current, ports = one_port}, transformer = {["needs-current?"] = false, ["voltage-index"] = 1, handler = calculate_transformer, ports = {"prim-pos", "prim-neg", "sec-pos", "sec-neg"}}, voltage = {["needs-current?"] = true, ["voltage-index"] = 1, handler = calculate_voltage, ports = one_port}}
do
  __fnl_global__node_2dtable = {}
  __fnl_global__node_2dtable["__index"] = __fnl_global__node_2dtable
  local function _0_(cls_0_, ...)
    local inst_0_ = {}
    local function _1_(cls, self)
      assert((nil ~= self), string.format("Missing argument %s on %s:%s", "self", "sources/mods/electricity/sim.fnl", 69))
      assert((nil ~= cls), string.format("Missing argument %s on %s:%s", "cls", "sources/mods/electricity/sim.fnl", 69))
      self.nodes = {[ground] = 0}
      self["node-count"] = 0
      self.components = 0
      for model_name, _ in pairs(circuit_models) do
        self[model_name] = 0
      end
      return nil
    end
    _1_(cls_0_, inst_0_, ...)
    setmetatable(inst_0_, cls_0_)
    return inst_0_
  end
  setmetatable(__fnl_global__node_2dtable, {__call = _0_})
end
__fnl_global__node_2dtable["add-to-nodes"] = function(self, node_str)
  if not self.nodes[node_str] then
    self["node-count"] = (self["node-count"] + 1)
    self.nodes[node_str] = self["node-count"]
  end
  return self.nodes[node_str]
end
local function map_nodes(circ)
  local tbl = __fnl_global__node_2dtable()
  for _, elem in ipairs(circ) do
    tbl.components = (tbl.components + 1)
    tbl[elem.type] = (tbl[elem.type] + 1)
    local model = circuit_models[elem.type]
    for _0, port in ipairs(model.ports) do
      elem[port] = tbl["add-to-nodes"](tbl, elem[port])
    end
  end
  return tbl
end
local function solve_aux(tbl, circ)
  local g2_count = 0
  for model_name, model in pairs(circuit_models) do
    g2_count = (g2_count + (tbl[model_name] * model["voltage-index"]))
  end
  local matrix_size = (tbl["node-count"] + g2_count)
  local A = matrix(matrix_size, matrix_size)
  local b = matrix(matrix_size, 1)
  local g2_index = (tbl["node-count"] + 1)
  for _, elem in ipairs(circ) do
    local model = circuit_models[elem.type]
    model.handler(A, b, elem, g2_index)
    if model["needs-current?"] then
      elem["current-index"] = g2_index
    end
    g2_index = (model["voltage-index"] + g2_index)
  end
  local solution = linsolve(A, b)
  local res = {currents = {}, voltages = {}}
  for name, pin in pairs(tbl.nodes) do
    local v = (solution:get(pin, 1) or real(0))
    res.voltages[name] = v
  end
  res.voltages[ground] = real(0)
  for id, elem in ipairs(circ) do
    if (elem["current-index"] ~= nil) then
      res.currents[elem.name] = solution:get(elem["current-index"], 1)
    end
  end
  return res
end
local function _0_(circ)
  return solve_aux(map_nodes(circ), circ)
end
circsolve = _0_
return nil
