loria = {}
dofile((minetest.get_modpath("loria") .. "/" .. "basic.lua"))
dofile((minetest.get_modpath("loria") .. "/" .. "prelude.lua"))
import("loria", "greet", "conf", "inv_crafts", "creative", "tint", "biomes", "ores", "mushrooms_nodes", "small_mushrooms", "mapgen", "liquids", "nodes", "gases_arch", "gases", "items", "craft", "mushrooms", "hud", "sky", "player", "compatibility", "pickaxe")
local start_items = {["furnace:refiner_item"] = 1, ["loria:empty_balloon"] = 1, ["loria:oxygen_balloon"] = 1, ["loria:silicon_box"] = 1, ["radiation:sign"] = 15}
local on_start_buckets = 2
local max_height = 31000
local space_suit_strength = 20
player_api.register_model("player.b3d", {animation_speed = 30, animations = {lay = {x = 162, y = 166}, mine = {x = 189, y = 198}, sit = {x = 81, y = 160}, stand = {x = 0, y = 79}, walk = {x = 168, y = 187}, walk_mine = {x = 200, y = 219}}, collisionbox = {-0.29999999999999999, 0, -0.29999999999999999, 0.29999999999999999, 1.7, 0.29999999999999999}, eye_height = 1.47, stepheight = 0.59999999999999998})
oxygen_hud = {}
local function _0_(player)
  local name = player:get_player_name()
  player:hud_set_flags({healthbar = false})
  oxygen_hud[name] = player:hud_add({alignment = "right", hud_elem_type = "text", number = 16777215, offset = {x = 150, y = 0}, position = {x = 0, y = 0.90000000000000002}, text = "N/A"})
  player:set_clouds({density = 0})
  loria["enough-fresh?"] = (player.set_sun and player.set_moon and player.set_stars)
  if loria["enough-fresh?"] then
    player:set_sun({scale = 0.5, sunrise_visible = false, texture = "star.png"})
    player:set_moon({scale = 7, texture = "gas_giant.png"})
    player:set_stars({scale = 0.5, star_color = "#ffffffff"})
  end
  player_api.set_model(player, "player.b3d")
  player:set_local_animation({x = 0, y = 79}, {x = 168, y = 187}, {x = 189, y = 198}, {x = 200, y = 219}, 30)
  return minetest.chat_send_player(name, "Welcome to Loria!")
end
minetest.register_on_joinplayer(_0_)
local function _1_(player, hp_change, reason)
  local meta = player:get_meta()
  local space_suit = meta:get_int("space_suit")
  if (reason.type == "set_hp") then
    return hp_change
  elseif (space_suit > 0) then
    if (reason.type ~= "node_damage") then
      local new = (space_suit + math.floor((hp_change / 2)))
      if (new > 0) then
        meta:set_int("space_suit", new)
      else
        meta:set_int("space_suit", 0)
      end
    end
    return 0
  else
    return hp_change
  end
end
minetest.register_on_player_hpchange(_1_, true)
local function init_inv(player)
  local name = player:get_player_name()
  local inv = player:get_inventory()
  inv:set_size("oxygen", 1)
  inv:set_size("antiradiation", 1)
  inv:set_size("input", 9)
  inv:set_size("output", 9)
  inv:add_item("main", {count = 1, name = "loria:drill"})
  inv:add_item("oxygen", {name = "loria:oxygen_balloon"})
  for name0, count in pairs(start_items) do
    inv:add_item("main", {count = count, name = name0})
  end
  for i = 1, on_start_buckets do
    inv:add_item("main", "loria:bucket_empty")
  end
  return nil
end
local function _2_(player)
  init_inv(player)
  local meta = player:get_meta()
  meta:set_int("oxygen", 0)
  meta:set_float("radiation", 0)
  meta:set_float("received_dose", 0)
  meta:set_float("dose_damage_limit", 1)
  return meta:set_int("space_suit", space_suit_strength)
end
minetest.register_on_newplayer(_2_)
local function _3_(player)
  local meta = player:get_meta()
  player:set_hp(20)
  meta:set_float("received_dose", 0)
  meta:set_float("dose_damage_limit", 1)
  return meta:set_int("space_suit", space_suit_strength)
end
minetest.register_on_respawnplayer(_3_)
local function _4_(_)
  for _0, player in ipairs(minetest.get_connected_players()) do
    local pos = player:get_pos()
    if (pos.y ~= ( - max_height)) then
      local h = player:get_pos().y
      local gravity = ((max_height / (h + max_height)) ^ 2)
      player:set_physics_override({gravity = gravity})
    else
      player:set_physics_override({gravity = 1})
    end
  end
  return nil
end
minetest.register_globalstep(_4_)
local clear_radius = 500
local function _5_(name)
  local player = minetest.get_player_by_name(name)
  if player then
    local pos = player:get_pos()
    local name0 = player:get_player_name()
    local objs = minetest.get_objects_inside_radius(pos, clear_radius)
    for _, obj in pairs(objs) do
      local entity = obj:get_luaentity()
      if (entity and (entity.name == "__builtin:item")) then
        obj:remove()
      end
    end
    return nil
  end
end
minetest.register_chatcommand("clearitems", {description = ("Deletes all items in " .. clear_radius .. " meters"), func = _5_, params = "", privs = {}})
minetest.register_privilege("kill", {description = "Allow to use \226\128\156/kill\226\128\157 command"})
local function _6_(name_e2_82_81, name_e2_82_82)
  local name = nil
  if (name_e2_82_81 ~= "") then
    name = name_e2_82_81
  else
    name = name_e2_82_82
  end
  local player = minetest.get_player_by_name(name)
  if player then
    return player:set_hp(0)
  end
end
return minetest.register_chatcommand("kill", {description = "Kills player", func = _6_, params = "[name]", privs = {kill = true}})
