liquids = {hydrochloric_acid = {alpha = 30, animated_flowing_texture = "loria_liquid_flowing_animated.png", animated_texture = "loria_liquid_source_animated.png", bucket_description = "Hydrochloric acid (HCl)", bucket_image = "bucket_hydrochloric_acid.png", damage = 10, liquid_viscosity = 1, post_effect_color = {a = 30, b = 255, g = 255, r = 255}, texture = "loria_liquid.png"}, lucidum = {alpha = 150, animated_flowing_texture = "loria_liquid_flowing_animated.png^[colorize:#0080ff", animated_texture = "loria_liquid_source_animated.png^[colorize:#0080ff", bucket_description = "Lucidum", bucket_image = "bucket_lucidum.png", light_source = 13, liquid_viscosity = 3, post_effect_color = {a = 150, b = 255, g = 128, r = 0}, texture = "loria_liquid.png^[colorize:#0080ff"}, mercury = {alpha = 255, animated_flowing_texture = "loria_mercury_animated.png", animated_texture = "loria_mercury_animated.png", bucket_description = "Mercury (Hg)", bucket_image = "bucket_mercury.png", damage_per_second = 2, liquid_viscosity = 7, post_effect_color = {a = 252, b = 150, g = 150, r = 150}, texture = "loria_mercury.png"}, polluted_mercury = {alpha = 255, animated_flowing_texture = "loria_mercury_animated.png", animated_texture = "loria_mercury_animated.png", bucket_description = "Polluted (U, Th) mercury", bucket_image = "bucket_mercury.png", damage_per_second = 3, liquid_viscosity = 7, post_effect_color = {a = 252, b = 150, g = 150, r = 150}, texture = "loria_mercury.png"}, potassium_hydroxide = {alpha = 50, animated_flowing_texture = "loria_liquid_flowing_animated.png", animated_texture = "loria_liquid_source_animated.png", bucket_description = "Potassium hydroxide (KOH)", bucket_image = "bucket_potassium_hydroxide.png", damage = 3, liquid_viscosity = 1, post_effect_color = {a = 30, b = 255, g = 255, r = 255}, texture = "loria_liquid.png"}, potassium_permanganate = {alpha = 160, animated_flowing_texture = "loria_potassium_permanganate_animated.png", animated_texture = "loria_potassium_permanganate_animated.png", bucket_description = "Potassium permanganate (KMnO4)", bucket_image = "bucket_potassium_permanganate.png", liquid_viscosity = 1, post_effect_color = {a = 100, b = 130, g = 0, r = 160}, texture = "loria_potassium_permanganate.png"}, sulfur_trioxide = {alpha = 100, animated_flowing_texture = "loria_liquid_flowing_animated.png", animated_texture = "loria_liquid_source_animated.png", bucket_description = "Sulfur trioxide (SO3)", bucket_image = "bucket_sulfur_trioxide.png", damage = 5, liquid_viscosity = 1, post_effect_color = {a = 30, b = 255, g = 255, r = 255}, texture = "loria_liquid.png"}, trisilane = {alpha = 70, animated_flowing_texture = "loria_liquid_flowing_animated.png", animated_texture = "loria_liquid_source_animated.png", bucket_description = "Trisilane (Si3H8)", bucket_image = "bucket_trisilane.png", is_fuel = true, liquid_viscosity = 1, post_effect_color = {a = 70, b = 255, g = 255, r = 255}, texture = "loria_liquid.png"}, water = {alpha = 160, animated_flowing_texture = "loria_water_flowing_animated.png", animated_texture = "loria_water_source_animated.png", bucket_description = "Water (H2O)", bucket_image = "bucket_water.png", liquid_viscosity = 2, post_effect_color = {a = 103, b = 90, g = 60, r = 30}, texture = "loria_water.png"}}
ores = {aluminium = {conductor = 1, formula = "Al", has_ingot = true, wherein = {"cobalt_blue", "cinnabar", "chromia"}}, americium_trifluoride = {formula = "AmF3", has_ingot = false, light_source = 10, radioactive = true, wherein = {"cobalt_blue", "cinnabar", "chromium_fluoride"}, y_min = -243}, calcium = {conductor = 1, formula = "Ca", has_ingot = true, wherein = {"chromium_fluoride"}, y_max = -700, y_min = -1200}, copper = {conductor = 1, formula = "Cu", has_ingot = true, wherein = {"cobalt_blue", "cinnabar"}}, cuprous_oxide = {formula = "Cu2O", has_ingot = false, wherein = {"cobalt_blue", "chromia"}, y_max = 0, y_min = -70}, magnesium = {formula = "Mg", has_ingot = true, wherein = {"cobalt_blue", "cinnabar", "chromia"}, y_max = -600, y_min = -900}, magnetite = {formula = "FeO * Fe2O3", has_ingot = false, wherein = {"cobalt_blue", "cinnabar", "chromium_fluoride"}, y_max = -200, y_min = -500}, molybdenum = {formula = "Mo", has_ingot = true, wherein = {"cobalt_blue", "cinnabar"}, y_max = -500, y_min = -800}, platinum = {conductor = 1, formula = "Pt", has_ingot = true, wherein = {"cobalt_blue", "cinnabar"}, y_max = -150, y_min = -300}, plutonium_trifluoride = {formula = "PuF3", has_ingot = false, radioactive = true, wherein = {"cobalt_blue", "cinnabar", "chromium_fluoride"}}, potassium = {formula = "K", has_ingot = true, wherein = {"cobalt_blue", "cinnabar", "chromia", "chromium_fluoride"}}, thorium_iodide = {formula = "ThI4", has_ingot = false, radioactive = true, wherein = {"cobalt_blue", "cinnabar", "chromium_fluoride", "chromia"}}, uranium_tetrachloride = {formula = "UCl4", has_ingot = false, radioactive = true, wherein = {"cobalt_blue", "cinnabar", "chromium_fluoride", "chromia"}}, wolfram = {conductor = 1, formula = "W", has_ingot = true, wherein = {"cobalt_blue", "cinnabar"}, y_max = -300, y_min = -1500}, zinc = {formula = "Zn", has_ingot = true, wherein = {"cobalt_blue", "cinnabar"}}}
grasses = {avarum = {biomes = "loria:purple_swamp", max_height = 4, place_on = "loria:ammonium_manganese_pyrophosphate"}, cruento = {biomes = "loria:purple_swamp", fill_ratio = 0.001, max_height = 6, place_on = "loria:ammonium_manganese_pyrophosphate"}, lectica = {biomes = "loria:acidic_landscapes", max_height = 5, place_on = "loria:sodium_peroxide"}, rami = {biomes = "loria:purple_swamp", max_height = 4, place_on = "loria:ammonium_manganese_pyrophosphate"}, spears = {biomes = "loria:purple_swamp", max_height = 4, place_on = "loria:ammonium_manganese_pyrophosphate"}, truncus = {biomes = "loria:azure", max_height = 7, place_on = "loria:copper_sulfate", variants = {"hyacinthum", "viridi", "purpura"}}, veteris = {biomes = "loria:acidic_landscapes", max_height = 8, place_on = "loria:sodium_peroxide"}}
giant_mushrooms = {"viridi_petasum", "colossus", "column", "turris", "rete", "timor"}
timor = {}
timor["body-names"] = {"light green", "blue", "red", "green", "purple"}
timor.colours = #timor["body-names"]
local function _0_(idx)
  return ("loria:timor_body_" .. idx)
end
timor["body-nodes"] = map(_0_, range(timor.colours))
wires = {{name = "copper", resis = 0.0225}, {name = "aluminium", resis = 0.036}, {name = "wolfram", resis = 0.055}, {name = "lead", resis = 0.221}, {name = "platinum", resis = 0.098}, {name = "calcium", resis = 0.046}, {name = "uranium", resis = 0.295}, {name = "thorium", resis = 0.1862}, {name = "plutonium", resis = 150}}
brickable = {["loria:ammonium_manganese_pyrophosphate"] = {crumbly = true}, ["loria:cinnabar"] = {crumbly = true}, ["loria:lead_sulfate"] = {crumbly = true}, ["loria:mercury_oxide"] = {crumbly = true}, ["loria:plutonium_dioxide"] = {refractory = true}, ["loria:red_mercury_oxide"] = {crumbly = true}, ["loria:thorium_dioxide"] = {crumbly = true}, ["loria:uranium_tetrachloride"] = {crumbly = true}}
small_mushrooms = {caput = {biomes = "loria:redland", damage = 15, fill_ratio = 0.01, max_radiation = 10, optimal_light = 11, optimal_radiation = 5, place_on = {"loria:cinnabar", "loria:red_mercury_oxide", "loria:mercury_oxide"}}, conc = {biomes = "loria:acidic_landscapes", damage = 16, fill_ratio = 0.01, place_on = "loria:sodium_peroxide"}, deus = {biomes = "loria:azure_bottom", damage = 20, features = {light_source = 6}, fill_ratio = 0.1, place_on = "loria:cobalt_blue", y_max = 0, y_min = -31000}, grebe = {biomes = "loria:purple_swamp", damage = 11, fill_ratio = 0.01, place_on = "loria:ammonium_manganese_pyrophosphate"}, infernum = {biomes = "loria:azure_bottom", damage = 14, features = {light_source = 8}, fill_ratio = 0.1, place_on = "loria:cobalt_blue", y_max = 0, y_min = -31000}, periculum = {biomes = "loria:purple_swamp", damage = 18, features = {light_source = 3}, fill_ratio = 0.01, place_on = "loria:ammonium_manganese_pyrophosphate"}, picea = {biomes = "loria:azure", damage = 9, fill_ratio = 0.05, place_on = "loria:copper_sulfate"}, pulchram = {damage = 3}, purpura = {biomes = "loria:azure", features = {light_source = 5}, fill_ratio = 0.05, place_on = "loria:copper_sulfate"}, pusilli = {biomes = "loria:redland", damage = 5, fill_ratio = 0.01, max_radiation = 10, optimal_light = 11, optimal_radiation = 5, place_on = {"loria:cinnabar", "loria:red_mercury_oxide", "loria:mercury_oxide"}}, quercu = {biomes = "loria:redland", damage = 7, optimal_light = 11, place_on = {"loria:cinnabar", "loria:red_mercury_oxide", "loria:mercury_oxide"}}, rosea = {biomes = "loria:azure", damage = 4, fill_ratio = 0.05, place_on = "loria:copper_sulfate"}, secreta = {biomes = "loria:purple_swamp", damage = 12, fill_ratio = 0.01, place_on = "loria:ammonium_manganese_pyrophosphate"}, vastatorem = {biomes = "loria:reptile_house", features = {light_source = 8}, fill_ratio = 0.005, place_on = "loria:nickel_nitrate"}, vult = {biomes = "loria:azure_bottom", damage = 10, features = {light_source = 6}, fill_ratio = 0.1, place_on = "loria:cobalt_blue", y_max = 0, y_min = -31000}}
pickaxes = {aluminium = {groupcaps = {cracky = {times = {5, 3, 2}, uses = 20}, crumbly = {times = {7, 5, 4}, uses = 30}}}, calcium = {groupcaps = {cracky = {times = {6, 4, 3}, uses = 15}, crumbly = {times = {8, 6, 5}, uses = 40}}}, copper = {groupcaps = {cracky = {times = {6, 4, 3}, uses = 20}, crumbly = {times = {8, 6, 5}, uses = 40}}}, magnesium = {groupcaps = {cracky = {times = {4, 3, 1}, uses = 25}, crumbly = {times = {6, 5, 3}, uses = 50}}}, molybdenum = {groupcaps = {cracky = {times = {2, 1, 0.5}, uses = 100}, crumbly = {times = {4, 3, 1.5}, uses = 200}}}, platinum = {groupcaps = {cracky = {times = {2.5, 2, 1}, uses = 70}, crumbly = {times = {5.5, 4, 3}, uses = 140}}}, plutonium = {groupcaps = {cracky = {times = {1.5, 0.7, 0.4}, uses = 270}, crumbly = {times = {2.5, 1.5, 0.7}, uses = 350}}}, potassium = {groupcaps = {cracky = {times = {7, 6, 5}, uses = 4}, crumbly = {times = {9.9, 8.5, 5.5}, uses = 5}}}, thorium = {groupcaps = {cracky = {times = {6, 4, 2}, uses = 40}, crumbly = {times = {7, 5, 3}, uses = 100}}}, uranium = {groupcaps = {cracky = {times = {1.5, 0.7, 0.4}, uses = 250}, crumbly = {times = {2.5, 1.7, 1}, uses = 290}}}, wolfram = {groupcaps = {cracky = {times = {1, 0.5, 0.3}, uses = 300}, crumbly = {times = {2, 1, 0.5}, uses = 400}}}, zinc = {groupcaps = {cracky = {times = {5, 4, 3}, uses = 25}, crumbly = {times = {7, 6, 5}, uses = 50}}}}
return nil
