local node_coeff = 100
local wire = {}
wire.top = {(-1 / 16), (-1 / 2), (-1 / 16), (1 / 16), (1 / 2), (1 / 16)}
wire.core = {(-1 / 16), (-1 / 2), (-1 / 16), (1 / 16), ((-1 / 2) + (1 / 16)), (1 / 16)}
wire.front = {(-1 / 16), (-1 / 2), (-1 / 2), (1 / 16), ((-1 / 2) + (1 / 16)), (1 / 16)}
wire.back = {(-1 / 16), (-1 / 2), (-1 / 16), (1 / 16), ((-1 / 2) + (1 / 16)), (1 / 2)}
wire.left = {(-1 / 2), (-1 / 2), (-1 / 16), (1 / 16), ((-1 / 2) + (1 / 16)), (1 / 16)}
wire.right = {(-1 / 16), (-1 / 2), (-1 / 16), (1 / 2), ((-1 / 2) + (1 / 16)), (1 / 16)}
local wire_box = {connect_back = wire.back, connect_bottom = wire.core, connect_front = wire.front, connect_left = wire.left, connect_right = wire.right, connect_top = wire.top, fixed = wire.core, type = "connected"}
local wire_overlap_box = {fixed = {wire.left, wire.right, {(-1 / 16), (-1 / 2), (-1 / 2), (1 / 16), ((-1 / 2) + (1 / 16)), (-4 / 16)}, {(1 / 16), (-1 / 2), (1 / 2), (-1 / 16), ((-1 / 2) + (1 / 16)), (4 / 16)}, {(1 / 16), (-1 / 16), (-4 / 16), (-1 / 16), 0, (4 / 16)}, {(-1 / 16), (-1 / 2), (-3 / 16), (1 / 16), 0, (-4 / 16)}, {(1 / 16), (-1 / 2), (3 / 16), (-1 / 16), 0, (4 / 16)}}, type = "fixed"}
local function wire_model(resis)
  local function _0_(pos, id)
    local center = hash_node_pos(pos)
    local res = {}
    for idx, vect in ipairs(neighbors) do
      table.insert(res, {name = (id .. "-" .. idx), neg = hash_node_connect(pos, vector.add(pos, vect)), pos = center, type = "consumer", value = resis})
    end
    return {}, res
  end
  return _0_
end
local function wire_overlap_model(resis)
  local function _0_(pos, id)
    local conn = twoport(pos)
    return {}, {{name = (id .. "-fst"), neg = conn["sec\226\130\129"], pos = conn["prim\226\130\129"], type = "consumer", value = resis}, {name = (id .. "-snd"), neg = conn["sec\226\130\130"], pos = conn["prim\226\130\130"], type = "consumer", value = resis}}
  end
  return _0_
end
local insulator_textures = {"electricity_insulator.png", "electricity_insulator.png", "electricity_insulator_side.png", "electricity_insulator_side.png", "electricity_insulator_side.png", "electricity_insulator_side.png"}
local function wire_textures(name)
  local function _0_(...)
    return ("electricity_" .. name .. ...)
  end
  return map(_0_, {"_wire.png", "_wire.png", "_wire_side.png", "_wire_side.png", "_wire_side.png", "_wire_side.png"})
end
local function register_wire(conf)
  local tiles = wire_textures(conf.name)
  local inv_image = ("electricity_" .. conf.name .. "_wire_item.png")
  local wire_name = (capitalization(conf.name) .. " wire")
  local wire_desc = {connects_to = {"group:source", "group:conductor", "group:disabled_electric_tool"}, drawtype = "nodebox", groups = {conductor = 1, crumbly = 3, dig_immediate = 3, wire = 1}, is_ground_content = false, node_box = wire_box, on_destruct = reset_current, paramtype = "light", selection_box = wire_box, sunlight_propagates = true, use_texture_alpha = "blend"}
  minetest.register_node(("electricity:" .. conf.name .. "_wire"), union(wire_desc, {description = wire_name, inventory_image = inv_image, tiles = tiles, wield_image = inv_image}))
  minetest.register_alias(("electricity:" .. conf.name .. "_cable"), ("electricity:" .. conf.name .. "_wire"))
  do
    local insulated_inv_image = (inv_image .. "^electricity_insulator_item.png")
    minetest.register_node(("electricity:" .. conf.name .. "_insulated_wire"), union(wire_desc, {description = (wire_name .. " (insulated)"), inventory_image = insulated_inv_image, tiles = insulator_textures, wield_image = insulated_inv_image}))
  end
  minetest.register_node(("electricity:" .. conf.name .. "_wire_overlap"), {description = (capitalization(conf.name) .. " wire (overlap)"), drawtype = "nodebox", groups = {conductor = 1, crumbly = 3, dig_immediate = 3, wire = 1}, is_ground_content = false, node_box = wire_overlap_box, on_destruct = reset_current, paramtype = "light", selection_box = wire_overlap_box, sunlight_propagates = true, tiles = tiles, use_texture_alpha = "blend"})
  minetest.register_alias(("electricity:" .. conf.name .. "_cable_overlap"), ("electricity:" .. conf.name .. "_wire_overlap"))
  model[("electricity:" .. conf.name .. "_wire")] = wire_model(conf.resis)
  model[("electricity:" .. conf.name .. "_insulated_wire")] = wire_model(conf.resis)
  model[("electricity:" .. conf.name .. "_wire_overlap")] = wire_overlap_model(conf.resis)
  model[("loria:" .. conf.name)] = wire_model((conf.resis * node_coeff))
  return nil
end
return foreach(register_wire, wires)
