local function organic_3f(name)
  local function _0_(x)
    return starts_with(name, x)
  end
  return (find(_0_, {"loria:pars", "loria:truncus", "loria:viriditas", "loria:avarum", "loria:rami", "loria:spears", "loria:naga", "loria:petite"}) or ends_with(name, "_body") or small_mushrooms[name:sub((#"loria:" + 1))])
end
local function heavy_organic_3f(name)
  return ends_with(name, "_stem")
end
local function fuel_3f(name)
  local function _0_(x)
    return starts_with(name, x)
  end
  return find(_0_, {"loria:potassium", "loria:trisilane"})
end
local chlorine = {damage = 2, destroys = organic_3f, heavy = true, icon = "loria_chlorine_symbol.png", name = "chlorine", palette = "chlorine_palette.png", post_effect_color = {a = 50, b = 0, g = 255, r = 210}, reactions = {["loria:glow_stick"] = {gas = "loria:chlorine", result = "loria:blowed_out_glow_stick"}, ["loria:mercury"] = {result = "loria:mercury_chloride"}, ["loria:mercury_flowing"] = {result = "loria:mercury_chloride"}, ["loria:mercury_source"] = {result = "loria:mercury_chloride"}}}
local oxygen = {damage = 0, destroys = const(false), icon = "loria_oxygen_symbol.png", name = "oxygen", reactions = {["furnace:gas_active"] = {gas = "loria:fire", result = "furnace:gas_active"}, ["loria:cinnabar"] = {gas = "loria:sulfur_dioxide", result = "loria:mercury"}}, transparent = true}
local hydrogen = {damage = 0, destroys = const(false), icon = "loria_hydrogen_symbol.png", name = "hydrogen", reactions = {["furnace:gas_active"] = {gas = "loria:fire", result = "furnace:gas_active"}}, transparent = true}
local sulfur_dioxide = {damage = 1, destroys = const(false), heavy = true, icon = "loria_sulfur_dioxide_symbol.png", name = "sulfur_dioxide", reactions = {}, transparent = true}
local fluorine
local function _0_(name)
  return (organic_3f(name) or heavy_organic_3f(name))
end
fluorine = {damage = 5, destroys = _0_, heavy = true, icon = "loria_fluorine_symbol.png", name = "fluorine", palette = "fluorine_palette.png", post_effect_color = {a = 50, b = 164, g = 251, r = 255}, reactions = {["loria:glow_stick"] = {gas = "loria:fluorine", result = "loria:blowed_out_glow_stick"}, ["loria:mercury_oxide"] = {gas = "loria:oxygen", result = "loria:mercury_fluoride"}, ["loria:red_mercury_oxide"] = {gas = "loria:oxygen", result = "loria:mercury_fluoride"}}}
local fire
local function _1_(name)
  return (organic_3f(name) or heavy_organic_3f(name) or fuel_3f(name))
end
fire = {alpha = 230, damage = 10, destroys = _1_, light_source = 14, name = "fire", no_balloon = true, palette = "fire_palette.png", post_effect_color = {a = 150, b = 255, g = 255, r = 255}}
fire.reactions = {["loria:hydrogen"] = {gas = "loria:fire", result = "loria:fire"}, ["loria:oxygen"] = {gas = "loria:fire", result = "loria:fire"}, ["loria:trisilane_flowing"] = {gas = "loria:fire", result = "loria:fire"}, ["loria:trisilane_source"] = {gas = "loria:fire", result = "loria:fire"}}
local evaporates = {"loria:red_mercury_oxide", "loria:mercury_oxide", "loria:cinnabar", "loria:copper_sulfate", "loria:cobalt_blue", "loria:ammonium_manganese_pyrophosphate"}
local air = {result = "air"}
for _, name in ipairs(evaporates) do
  fire.reactions[name] = air
end
for name, _ in pairs(ores) do
  fire.reactions[("loria:" .. name)] = air
  fire.reactions[("loria:" .. name .. "_cinnabar")] = air
  fire.reactions[("loria:" .. name .. "_azure")] = air
end
return foreach(register_gas, {chlorine, oxygen, hydrogen, sulfur_dioxide, fluorine, fire})
