minetest.register_node("loria:test", {description = "For tests only", groups = {crumbly = 3}, tiles = {"loria_test.png"}})
minetest.register_node("loria:infinite_oxygen", {description = "Infinite oxygen", groups = {crumbly = 3}, tiles = {"loria_test.png^[colorize:#0000ff50"}})
minetest.register_node("loria:silicon", {description = "Silicon (Si)", groups = {crumbly = 2}, tiles = {"loria_silicon.png"}})
minetest.register_node("loria:magnesium_silicide", {description = "Magnesium silicide (Mg2Si)", groups = {crumbly = 2}, tiles = {"loria_magnesium_silicide.png"}})
minetest.register_node("loria:magnesium_oxide", {description = "Magnesium oxide (MgO)", groups = {crumbly = 2}, tiles = {"loria_magnesium_oxide.png"}})
minetest.register_node("loria:potassium_manganate", {description = "Potassium manganate (K2MnO4)", groups = {crumbly = 3}, tiles = {"loria_potassium_manganate.png"}})
minetest.register_node("loria:aluminium_oxide", {description = "Aluminium (III) oxide (Al2O3)", groups = {crumbly = 3}, tiles = {"loria_aluminium_oxide.png"}})
minetest.register_node("loria:manganese_dioxide", {description = "Manganese dioxide (MnO2)", groups = {crumbly = 3}, tiles = {"loria_manganese_dioxide.png"}})
minetest.register_node("loria:manganese_oxide", {description = "Manganese oxide (MnO)", groups = {crumbly = 3}, tiles = {"loria_manganese_oxide.png"}})
minetest.register_node("loria:ammonium_manganese_pyrophosphate", {description = "Ammonium manganese (III) pyrophosphate", groups = {crumbly = 2}, tiles = {"loria_ammonium_manganese_pyrophosphate.png"}})
minetest.register_node("loria:cinnabar", {description = "Cinnabar (HgS)", groups = {cracky = 2}, tiles = {"loria_cinnabar.png"}})
minetest.register_node("loria:copper_oxide", {description = "Copper (II) oxide (CuO)", groups = {crumbly = 2}, tiles = {"loria_copper_oxide.png"}})
minetest.register_node("loria:copper_sulfate_pure", {description = "Copper (II) sulfate (CuSO4)", groups = {crumbly = 2}, tiles = {"loria_copper_sulfate_pure.png"}})
minetest.register_node("loria:copper_sulfate", {description = "Copper (II) sulfate pentahydrate (CuSO4 * 5H2O)", groups = {crumbly = 2}, tiles = {"loria_copper_sulfate.png"}})
minetest.register_node("loria:mercury", {description = "Mercury (Hg)", groups = {cracky = 2}, tiles = {"loria_mercury.png"}})
minetest.register_node("loria:uranium", {description = "Uranium (U)", groups = {conductor = 1, cracky = 1}, tiles = {"loria_uranium.png"}})
minetest.register_node("loria:lead", {description = "Lead (Pb)", groups = {conductor = 1, cracky = 1}, tiles = {"loria_lead.png"}})
minetest.register_node("loria:brick", {description = "Brick", groups = {cracky = 2}, tiles = {"loria_brick.png"}})
minetest.register_node("loria:lead_case", {description = "Lead case", groups = {cracky = 2}, tiles = {"loria_lead_case.png"}})
minetest.register_node("loria:mercury_chloride", {description = "Mercury (II) chloride (HgCl2)", groups = {crumbly = 3}, tiles = {"loria_mercury_chloride.png"}})
minetest.register_node("loria:zinc_chloride", {description = "Zinc chloride (ZnCl2)", groups = {crumbly = 3}, tiles = {"loria_zinc_chloride.png"}})
minetest.register_node("loria:aluminium_chloride", {description = "Aluminium chloride (AlCl3)", groups = {crumbly = 3}, tiles = {"loria_aluminium_chloride.png"}})
minetest.register_node("loria:potassium_chloride", {description = "Potassium chloride (KCl)", groups = {crumbly = 3}, tiles = {"loria_potassium_chloride.png"}})
minetest.register_node("loria:mercury_fluoride", {description = "Mercury (II) fluoride (HgF2)", groups = {crumbly = 2}, tiles = {"loria_mercury_fluoride.png"}})
minetest.register_node("loria:lead_sulfate", {description = "Lead (II) sulfate (PbSO4)", groups = {crumbly = 1}, tiles = {"loria_lead_sulfate.png"}})
minetest.register_node("loria:lead_selenide", {description = "Lead (II) selenide (PbSe)", groups = {cracky = 1}, tiles = {"loria_lead_selenide.png"}})
minetest.register_node("loria:selenium", {description = "Selenium (Se)", groups = {crumbly = 1}, tiles = {"loria_selenium.png"}})
minetest.register_node("loria:sodium_peroxide", {description = "Sodium peroxide (Na2O2)", groups = {crumbly = 2}, tiles = {"loria_sodium_peroxide.png"}})
minetest.register_node("loria:sodium_oxide", {description = "Sodium oxide (Na2O)", groups = {crumbly = 2}, tiles = {"loria_sodium_oxide.png"}})
minetest.register_node("loria:cobalt_sulfate", {description = "Cobalt sulfate (CoSO4)", groups = {crumbly = 2}, tiles = {"loria_cobalt_sulfate.png"}})
minetest.register_node("loria:chromia", {description = "Chromium (III) oxide (Cr2O3)", groups = {crumbly = 1}, tiles = {"loria_chromia.png"}})
minetest.register_node("loria:chromium_trioxide", {description = "Chromium trioxide (CrO3)", groups = {cracky = 2}, tiles = {"loria_chromium_trioxide.png"}})
minetest.register_node("loria:chromic_chloride", {description = "Chromium (III) chloride (CrCl3)", groups = {cracky = 2}, tiles = {"loria_chromic_chloride.png"}})
minetest.register_node("loria:chromium", {description = "Chromium (Cr)", groups = {cracky = 1}, tiles = {"loria_chromium.png"}})
minetest.register_node("loria:nickel_nitrate", {description = "Nickel (II) nitrate (Ni(NO3)2)", groups = {crumbly = 1}, tiles = {"loria_nickel_nitrate.png"}})
minetest.register_node("loria:chromium_fluoride", {description = "Chromium (III) fluoride (CrF3)", groups = {cracky = 2}, tiles = {"loria_chromium_fluoride.png"}})
minetest.register_node("loria:chromium_fluoride_capital", {description = "Machined chromium fluoride (I)", groups = {cracky = 1}, tiles = {"loria_chromium_fluoride.png^loria_capital.png"}})
local function _0_(postfix)
  return ("loria_chromium_fluoride.png^" .. postfix)
end
minetest.register_node("loria:chromium_fluoride_shaft", {description = "Machined chromium fluoride (II)", groups = {cracky = 1}, paramtype2 = "wallmounted", tiles = map(_0_, {"loria_shaft_top_bottom.png", "loria_shaft_top_bottom.png", "loria_shaft.png", "loria_shaft.png", "loria_shaft.png", "loria_shaft.png"})})
local function _1_(postfix)
  return ("loria_chromium_fluoride.png^" .. postfix)
end
minetest.register_node("loria:chromium_fluoride_base", {description = "Machined chromium fluoride (III)", groups = {cracky = 1}, paramtype2 = "wallmounted", tiles = map(_1_, {"loria_base_top.png", "loria_base_bottom.png", "loria_base.png", "loria_base.png", "loria_base.png", "loria_base.png"})})
local function _2_(postfix)
  return ("loria_chromium_fluoride.png^" .. postfix)
end
minetest.register_node("loria:chromium_fluoride_volutes", {description = "Machined chromium fluoride (IV)", groups = {cracky = 1}, paramtype2 = "wallmounted", tiles = map(_2_, {"loria_volutes_top.png", "loria_volutes_bottom.png", "loria_volutes.png", "loria_volutes.png", "loria_volutes.png", "loria_volutes.png"})})
minetest.register_node("loria:chromium_fluoride_floor", {description = "Machined chromium fluoride (V)", groups = {cracky = 1}, tiles = {"loria_chromium_fluoride.png^loria_floor.png"}})
minetest.register_node("loria:chromium_fluoride_cross", {description = "Machined chromium fluoride (VI)", groups = {cracky = 1}, tiles = {"loria_chromium_fluoride.png^loria_cross.png"}})
minetest.register_node("loria:chromium_fluoride_hooked_cross", {description = "Machined chromium fluoride (VII)", groups = {cracky = 1}, tiles = {"loria_chromium_fluoride.png^loria_hooked_cross.png"}})
minetest.register_node("loria:chromium_fluoride_block", {description = "Machined chromium fluoride (VIII)", groups = {cracky = 1}, tiles = {"loria_chromium_fluoride.png^loria_block.png"}})
minetest.register_node("loria:chromium_fluoride_filled_floor", {description = "Machined chromium fluoride (IX)", groups = {cracky = 1}, tiles = {"loria_chromium_fluoride.png^loria_filled_floor.png"}})
minetest.register_node("loria:lead_oxide", {description = "Lead (II) oxide (PbO)", groups = {crumbly = 2}, tiles = {"loria_lead_oxide.png"}})
minetest.register_node("loria:silicon_dioxide", {description = "Silicon dioxide (SiO2)", groups = {crumbly = 3}, tiles = {"loria_silicon_dioxide.png"}})
minetest.register_node("loria:fused_quartz", {description = "Fused quartz (glass)", drawtype = "glasslike", groups = {cracky = 3, oddly_breakable_by_hand = 3, snappy = 2}, is_ground_content = false, paramtype = "light", sunlight_propagates = true, tiles = {"loria_fused_quartz.png"}})
minetest.register_node("loria:calcium_fluoride", {description = "Calcium fluoride (CaF2)", groups = {crumbly = 2}, tiles = {"loria_calcium_fluoride.png"}})
minetest.register_node("loria:cobalt_blue", {description = "Cobalt blue (CoAl2O4)", groups = {crumbly = 2}, tiles = {"loria_cobalt_blue.png"}})
minetest.register_node("loria:mercury_oxide", {description = "Mercury (II) oxide (HgO)", groups = {crumbly = 2}, tiles = {"loria_mercury_oxide.png"}})
minetest.register_node("loria:red_mercury_oxide", {description = "Mercury (II) oxide (HgO, red)", groups = {crumbly = 2}, tiles = {"loria_red_mercury_oxide.png"}})
minetest.register_node("loria:sulfur", {description = "Sulfur (S)", groups = {crumbly = 2}, tiles = {"loria_sulfur.png"}})
minetest.register_node("loria:iodine", {description = "Iodine (I)", groups = {crumbly = 2}, tiles = {"loria_iodine.png"}})
minetest.register_node("loria:thorium", {description = "Thorium (Th)", groups = {conductor = 1, cracky = 1}, tiles = {"loria_thorium.png"}})
minetest.register_node("loria:thorium_dioxide", {description = "Thorium dioxide (ThO2)", groups = {cracky = 2}, tiles = {"loria_thorium_dioxide.png"}})
minetest.register_node("loria:plutonium", {description = "Plutonium (Pu)", groups = {conductor = 1, cracky = 1}, tiles = {"loria_plutonium.png"}})
minetest.register_node("loria:mushroom_mass", {description = "Mushroom mass", groups = {crumbly = 3}, tiles = {"loria_mushroom_mass.png"}})
minetest.register_node("loria:ferrous_oxide", {description = "Iron (II) oxide (FeO)", groups = {crumbly = 3}, tiles = {"loria_ferrous_oxide.png"}})
minetest.register_node("loria:ferric_oxide", {description = "Iron (III) oxide (Fe2O3)", groups = {crumbly = 3}, tiles = {"loria_ferric_oxide.png"}})
local glow_stick_selection_box = {type = "wallmounted", wall_bottom = {-0.1, -0.5, -0.1, 0.1, (-0.5 + 0.6), 0.1}, wall_side = {-0.5, -0.3, -0.1, (-0.5 + 0.3), 0.3, 0.1}, wall_top = {-0.1, (0.5 - 0.6), -0.1, 0.1, 0.5, 0.1}}
minetest.register_node("loria:blowed_out_glow_stick", {description = "Blowed out glow stick", drawtype = "torchlike", groups = {attached_node = 1, choppy = 2, dig_immediate = 3}, inventory_image = "loria_blowed_out_glow_stick_on_floor.png", is_ground_content = false, legacy_wallmounted = true, paramtype = "light", paramtype2 = "wallmounted", selection_box = glow_stick_selection_box, sunlight_propagates = true, tiles = {"loria_blowed_out_glow_stick_on_floor.png", "loria_blowed_out_glow_stick_on_ceiling.png", "loria_blowed_out_glow_stick.png"}, walkable = false, wield_image = "loria_blowed_out_glow_stick_on_floor.png"})
minetest.register_node("loria:glow_stick", {description = "Glow stick", drawtype = "torchlike", groups = {attached_node = 1, choppy = 2, dig_immediate = 3}, inventory_image = "loria_glow_stick_on_floor.png", is_ground_content = false, legacy_wallmounted = true, light_source = 10, paramtype = "light", paramtype2 = "wallmounted", selection_box = glow_stick_selection_box, sunlight_propagates = true, tiles = {"loria_glow_stick_on_floor.png", "loria_glow_stick_on_ceiling.png", "loria_glow_stick.png"}, walkable = false, wield_image = "loria_glow_stick_on_floor.png"})
local function _3_(pos)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  for _, lst in pairs(inv:get_lists()) do
    for _0, itemstack in ipairs(lst) do
      minetest.add_item(pos, itemstack)
    end
  end
  return nil
end
drop_everything = _3_
local function _4_(inv_size, formspec)
  local function _5_(pos)
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    meta:set_string("formspec", formspec)
    return inv:set_size("main", inv_size)
  end
  return _5_
end
setup_formspec = _4_
local lead_box_formspec = ("size[8,10.5]" .. "list[context;main;0,0;8,5;]" .. "list[current_player;main;0,6;8,1;]" .. "list[current_player;main;0,7.5;8,3;8]")
minetest.register_node("loria:lead_box", {description = "Lead box", groups = {cracky = 2}, on_construct = setup_formspec(40, lead_box_formspec), on_destruct = drop_everything, paramtype2 = "facedir", tiles = {"loria_lead_box_top.png", "loria_lead_box_bottom.png", "loria_lead_box_side.png", "loria_lead_box_side.png", "loria_lead_box_side.png", "loria_lead_box_front.png"}})
local silicon_box_formspec = ("size[8,8.5]" .. "list[context;main;0,0;8,3;]" .. "list[current_player;main;0,4;8,1;]" .. "list[current_player;main;0,5.5;8,3;8]")
minetest.register_node("loria:silicon_box", {description = "Silicon box", groups = {cracky = 2}, on_construct = setup_formspec(24, silicon_box_formspec), on_destruct = drop_everything, paramtype2 = "facedir", tiles = {"loria_silicon_box_top.png", "loria_silicon_box_bottom.png", "loria_silicon_box_side.png", "loria_silicon_box_side.png", "loria_silicon_box_side.png", "loria_silicon_box_front.png"}})
for name, _ in pairs(brickable) do
  local source = minetest.registered_nodes[name]
  local function _5_(tile)
    return (tile .. "^loria_brick_mask.png")
  end
  minetest.register_node((name .. "_brick"), {description = (source.description .. " brick"), drop = (name .. "_brick"), groups = {cracky = 3}, tiles = map(_5_, source.tiles)})
end
return nil
