local creative_3f = (minetest.settings):get_bool("creative_mode")
local craft_list_formspec = ""
local special_names = {["furnace:electric"] = "Electric furnace", ["furnace:gas"] = "Gas powered furnace (lead)", ["furnace:thorium"] = "Gas powered furnace (thorium)"}
local function process_content_name(name)
  return (special_names[name] or capitalization(name:gsub("^%a+:", "")))
end
local function process_stack_list(stack_list)
  local function _1_(stack)
    return string.format("%s,%d", process_content_name(stack.name), (stack.count or 1))
  end
  return map(_1_, stack_list)
end
local function process_craft(id, craft)
  local _in = process_stack_list(craft.input)
  local out = process_stack_list(craft.output)
  local N = math.max(#_in, #out)
  local res = string.format("%d,Input,N,Output,N", id)
  for idx = 1, N do
    local in_e2_80_b2 = (_in[idx] or ",")
    local out_e2_80_b2 = (out[idx] or ",")
    res = table.concat({res, "-", in_e2_80_b2, out_e2_80_b2}, ",")
  end
  return res
end
local function _2_()
  local function craft_list_append(s)
    craft_list_formspec = (craft_list_formspec .. s)
    return nil
  end
  local function append_table(name, tbl)
    craft_list_append(string.format(",%s,,,,", name))
    return craft_list_append(table.concat(imap(process_craft, tbl), ","))
  end
  local function sep()
    return craft_list_append(",")
  end
  craft_list_append("size[10,10]button[4,9;2,1;go_to_survival;Back]")
  craft_list_append("tablecolumns[text;text;text;text;text]")
  craft_list_append("table[0.5,0.5;9,8.5;craft_list;")
  append_table("Inventory", inv_crafts)
  sep()
  append_table("Furnace", furnace_crafts)
  sep()
  append_table("Furnace (high temp.)", high_temperature_crafts)
  sep()
  append_table("Refiner", refiner_crafts)
  return craft_list_append(";1]")
end
minetest.register_on_mods_loaded(_2_)
local function player_formspec()
  local str = ("size[9,10.5]" .. "label[0,0.5;Oxygen]" .. "list[context;oxygen;0,1;1,1;]" .. "label[0,2.5;Drugs]" .. "list[context;antiradiation;0,3;1,1;]" .. "label[2,0.5;Input]" .. "image[5,2;1,1;gui_arrow.png^[transformR270]" .. "button[5,3;1,1;craft_it;Craft]" .. "list[context;input;2,1;3,3;]" .. "label[6,0.5;Output]" .. "list[context;output;6,1;3,3;]" .. "list[context;main;0.5,6;8,1;]" .. "list[context;main;0.5,7.5;8,3;8]" .. "button[0.5,4.5;2,1;go_to_recipes;Recipes]")
  if creative_3f then
    return (str .. "button[3.5,4.5;2,1;go_to_creative;Creative]")
  else
    return str
  end
end
local creative_formspec_width, creative_formspec_height = 8, 4
local creative_inv = {}
local shift_min = 1
local shift_max = nil
local function _4_()
  for name, params in pairs(minetest.registered_items) do
    if not params.groups.not_in_creative_inventory then
      table.insert(creative_inv, name)
    end
  end
  local pages = math.floor((#creative_inv / creative_formspec_width))
  shift_max = (1 + (((pages - creative_formspec_height) + 1) * creative_formspec_width))
  return nil
end
minetest.register_on_mods_loaded(_4_)
local function creative_formspec(shift)
  return ("size[9,10.5]" .. "list[context;creative_inv;0.5,0.5;" .. creative_formspec_width .. "," .. creative_formspec_height .. ";" .. shift .. "]" .. "button[2.5,4.5;1,1;creative_up;Up]" .. "button[5.5,4.5;1,1;creative_down;Down]" .. "button[3.5,4.5;2,1;go_to_survival;Survival]" .. "list[context;main;0.5,6;8,1;]" .. "list[context;main;0.5,7.5;8,3;8]")
end
local function _6_(player, formname, fields)
  local inv = player:get_inventory()
  local meta = player:get_meta()
  if fields.go_to_creative then
    player:set_inventory_formspec(creative_formspec(meta:get_int("creative_shift")))
  elseif fields.go_to_survival then
    player:set_inventory_formspec(player_formspec())
  elseif fields.go_to_recipes then
    player:set_inventory_formspec(craft_list_formspec)
  elseif fields.creative_down then
    local shift = meta:get_int("creative_shift")
    local shift_e2_80_b2 = (shift + 8)
    local shift_e2_80_b3
    if (shift_e2_80_b2 > shift_max) then
      shift_e2_80_b3 = shift_max
    else
      shift_e2_80_b3 = shift_e2_80_b2
    end
    meta:set_int("creative_shift", shift_e2_80_b3)
    player:set_inventory_formspec(creative_formspec(shift_e2_80_b3))
  elseif fields.creative_up then
    local shift = meta:get_int("creative_shift")
    local shift_e2_80_b2 = (shift - 8)
    local shift_e2_80_b3
    if (shift_e2_80_b2 < shift_min) then
      shift_e2_80_b3 = shift_min
    else
      shift_e2_80_b3 = shift_e2_80_b2
    end
    meta:set_int("creative_shift", shift_e2_80_b3)
    player:set_inventory_formspec(creative_formspec(shift_e2_80_b3))
  end
  return inv:set_list("creative_inv", creative_inv)
end
minetest.register_on_player_receive_fields(_6_)
minetest.register_privilege("creative", {description = "Creative game mode", give_to_admin = false, give_to_singleplayer = false})
local creative_privs = {"fly", "fast", "give", "noclip", "settime", "teleport", "creative"}
local function _10_(player)
  local meta = player:get_meta()
  local inv = player:get_inventory()
  local name = player:get_player_name()
  meta:set_int("creative_shift", 1)
  inv:set_size("creative_inv", #creative_inv)
  inv:set_list("creative_inv", creative_inv)
  player:set_inventory_formspec(player_formspec())
  local privs = minetest.get_player_privs(name)
  local granted_3f = (creative_3f or nil)
  local function _11_(priv)
    privs[priv] = granted_3f
    return nil
  end
  foreach(_11_, creative_privs)
  return minetest.set_player_privs(name, privs)
end
minetest.register_on_joinplayer(_10_)
local function is_valid_balloon_3f(name)
  return (name == "loria:oxygen_balloon")
end
local function _12_(player, action, inventory, inventory_info)
  if (action == "move") then
    local inv = player:get_inventory()
    local stack = inv:get_stack(inventory_info.from_list, inventory_info.from_index)
    if (inventory_info.from_list == "output") then
      return 0
    elseif (inventory_info.from_list == "creative_inv") then
      stack:set_count((stack:get_count() + inventory_info.count))
      inv:set_stack("creative_inv", inventory_info.from_index, stack)
      return inventory_info.count
    elseif (inventory_info.to_list == "oxygen") then
      if is_valid_balloon_3f(stack:get_name()) then
        return stack:get_count()
      else
        return 0
      end
    elseif ((inventory_info.to_list == "output") or (inventory_info.to_list == "creative_inv")) then
      return 0
    else
      return stack:get_count()
    end
  elseif (action == "put") then
    if (inventory_info.listname == "oxygen") then
      if is_valid_balloon_3f((inventory_info.stack):get_name()) then
        return (inventory_info.stack):get_count()
      else
        return 0
      end
    elseif ((inventory_info.listname == "output") or (inventory_info.listname == "creative_inv")) then
      return 0
    else
      return (inventory_info.stack):get_count()
    end
  elseif (action == "take") then
    if (inventory_info.listname == "output") then
      return 0
    elseif (inventory_info.listname == "creative_inv") then
      return -1
    else
      return (inventory_info.stack):get_count()
    end
  end
end
return minetest.register_allow_player_inventory_action(_12_)
