bucket = {is_bucket = {}, liquids = {}}
local function opacity(texture, opacity0)
  return (texture .. "^[opacity:" .. opacity0)
end
local function _1_(itemstack, user, pointed_thing)
  assert((nil ~= pointed_thing), string.format("Missing argument %s on %s:%s", "pointed_thing", "sources/mods/loria/liquids.fnl", 13))
  assert((nil ~= user), string.format("Missing argument %s on %s:%s", "user", "sources/mods/loria/liquids.fnl", 13))
  assert((nil ~= itemstack), string.format("Missing argument %s on %s:%s", "itemstack", "sources/mods/loria/liquids.fnl", 13))
  if (pointed_thing.type == "node") then
    local n = minetest.get_node(pointed_thing.under)
    local liquiddef = bucket.liquids[n.name]
    if ((liquiddef ~= nil) and (liquiddef.source == n.name) and liquiddef.itemname) then
      minetest.add_node(pointed_thing.under, {name = "air"})
      return {name = liquiddef.itemname, wear = itemstack:get_wear()}
    end
  end
end
minetest.register_craftitem("loria:bucket_empty", {description = "Empty bucket", inventory_image = "bucket.png", liquids_pointable = true, on_use = _1_, stack_max = 1})
for name, params in pairs(liquids) do
  local source = ("loria:" .. name .. "_source")
  local flowing = ("loria:" .. name .. "_flowing")
  local itemname = ("loria:bucket_" .. name)
  local texture_e2_82_81 = opacity(params.animated_texture, params.alpha)
  local texture_e2_82_82 = opacity(params.animated_flowing_texture, params.alpha)
  minetest.register_node(source, {buildable_to = true, damage_per_second = (params.damage_per_second or 0), description = (capitalization(name) .. " source"), diggable = false, drawtype = "liquid", drop = "", drowning = 1, groups = {liquid = 3, not_in_creative_inventory = 1}, is_ground_content = false, light_source = (params.light_source or 0), liquid_alternative_flowing = flowing, liquid_alternative_source = source, liquid_renewable = false, liquid_viscosity = params.liquid_viscosity, liquidtype = "source", paramtype = "light", pointable = false, post_effect_color = params.post_effect_color, tiles = {{animation = {aspect_h = 16, aspect_w = 16, length = 2, type = "vertical_frames"}, backface_culling = false, name = texture_e2_82_81}, {animation = {aspect_h = 16, aspect_w = 16, length = 2, type = "vertical_frames"}, backface_culling = true, name = texture_e2_82_81}}, use_texture_alpha = "blend", walkable = false})
  minetest.register_node(flowing, {buildable_to = true, damage_per_second = (params.damage_per_second or 0), description = ("Flowing " .. name), diggable = false, drawtype = "flowingliquid", drop = "", drowning = 1, groups = {liquid = 3, not_in_creative_inventory = 1}, is_ground_content = false, light_source = (params.light_source or 0), liquid_alternative_flowing = flowing, liquid_alternative_source = source, liquid_renewable = false, liquid_viscosity = params.liquid_viscosity, liquidtype = "flowing", paramtype = "light", paramtype2 = "flowingliquid", pointable = false, post_effect_color = params.post_effect_color, special_tiles = {{animation = {aspect_h = 16, aspect_w = 16, length = 0.8, type = "vertical_frames"}, backface_culling = false, name = texture_e2_82_82}, {animation = {aspect_h = 16, aspect_w = 16, length = 0.8, type = "vertical_frames"}, backface_culling = true, name = texture_e2_82_82}}, tiles = {params.texture}, use_texture_alpha = "blend", walkable = false})
  do end (bucket.liquids)[source] = {flowing = flowing, itemname = itemname, source = source}
  bucket.liquids[flowing] = bucket.liquids[source]
  bucket.is_bucket[itemname] = true
  local _4_
  if params.is_fuel then
    _4_ = minetest.register_tool
  else
    _4_ = minetest.register_craftitem
  end
  local function _6_(itemstack, user, pointed_thing)
    assert((nil ~= pointed_thing), string.format("Missing argument %s on %s:%s", "pointed_thing", "sources/mods/loria/liquids.fnl", 119))
    assert((nil ~= user), string.format("Missing argument %s on %s:%s", "user", "sources/mods/loria/liquids.fnl", 119))
    assert((nil ~= itemstack), string.format("Missing argument %s on %s:%s", "itemstack", "sources/mods/loria/liquids.fnl", 119))
    if (pointed_thing.type == "node") then
      local n = minetest.get_node(pointed_thing.under)
      if not bucket.liquids[n.name] then
        minetest.add_node(pointed_thing.above, {name = source})
      elseif (n.name ~= source) then
        minetest.add_node(pointed_thing.under, {name = source})
      else
        nope()
      end
      return {name = "loria:bucket_empty", wear = itemstack:get_wear()}
    end
  end
  _4_(itemname, {description = params.bucket_description, inventory_image = params.bucket_image, liquids_pointable = true, on_use = _6_, stack_max = 1})
end
return nil
