local no_top_neighbors = {vector.new(1, 0, 0), vector.new(-1, 0, 0), vector.new(0, -1, 0), vector.new(0, 0, 1), vector.new(0, 0, -1)}
local function get_neighbors(pos, heavy)
  local add_pos
  do
    local _1_ = pos
    local function _2_(...)
      return vector.add(_1_, ...)
    end
    add_pos = _2_
  end
  local function _3_()
    if heavy then
      return no_top_neighbors
    else
      return neighbors
    end
  end
  return map(add_pos, _3_())
end
local heavy_3f = {}
local function _4_(name)
  return ((minetest.get_item_group(name, "gas") > 0) and minetest.registered_nodes[name].description)
end
detect_gas = _4_
local function process_gas(gas, pos)
  local node = minetest.get_node(pos)
  local accepted = {pos}
  for _, v in ipairs(get_neighbors(pos, (heavy_3f)[gas.name])) do
    local neighbor = minetest.get_node(v)
    local reaction = gas.reactions[neighbor.name]
    if (reaction ~= nil) then
      minetest.swap_node(v, {name = reaction.result, param1 = neighbor.param1, param2 = neighbor.param2})
      if reaction.gas then
        minetest.swap_node(pos, {name = reaction.gas, param1 = node.param1, param2 = node.param2})
      else
        minetest.set_node(pos, {name = "air"})
      end
    elseif ((neighbor.name == node.name) or (neighbor.name == "air") or gas.destroys(neighbor.name)) then
      table.insert(accepted, v)
    elseif _ then
      nope()
    end
  end
  node["param2"] = (node.param2 - #accepted - -1)
  if (node.param2 >= 128) then
    for _, v in ipairs(accepted) do
      minetest.swap_node(v, node)
    end
    return nil
  else
    return minetest.set_node(pos, {name = "air"})
  end
end
local gas_levels = 255
local function _8_(gas)
  heavy_3f[gas.name] = gas.heavy
  local _9_
  if gas.transparent then
    _9_ = "airlike"
  else
    _9_ = "glasslike"
  end
  minetest.register_node(("loria:" .. gas.name), {buildable_to = true, damage_per_second = gas.damage, description = gas.name, drawtype = _9_, drop = {}, groups = {gas = 1, not_in_creative_inventory = 1}, light_source = (gas.light_source or 0), palette = gas.palette, paramtype = "light", paramtype2 = "color", pointable = false, post_effect_color = gas.post_effect_color, sunlight_propagates = true, tiles = {("loria_gas.png^[opacity:" .. (gas.alpha or 128))}, use_texture_alpha = "blend", walkable = false})
  local _12_
  do
    local _11_ = gas
    local function _13_(...)
      return process_gas(_11_, ...)
    end
    _12_ = _13_
  end
  minetest.register_abm({action = _12_, chance = 2, interval = 1, nodenames = {("loria:" .. gas.name)}})
  if not gas.no_balloon then
    local function _14_(itemstack, user, pointed_thing)
      if (pointed_thing.type == "node") then
        local wear = (65535 - itemstack:get_wear())
        local value = math.ceil((wear * (128 / 65535)))
        minetest.add_node(pointed_thing.above, {name = ("loria:" .. gas.name), param2 = (127 + value)})
        return {name = "loria:empty_balloon"}
      end
    end
    return minetest.register_tool(("loria:" .. gas.name .. "_balloon"), {description = (capitalization(gas.name) .. " balloon"), inventory_image = ("loria_empty_balloon.png^[combine:16x16:0,0=" .. gas.icon), on_use = _14_, stack_max = 1})
  end
end
register_gas = _8_
local attack_radius = 30
local attack_step = 10
local function _17_(name, gas)
  local player = minetest.get_player_by_name(name)
  if player then
    local pos = player:get_pos()
    for x = (pos.x - attack_radius), (pos.x + attack_radius), attack_step do
      for z = (pos.z - attack_radius), (pos.z + attack_radius), attack_step do
        minetest.set_node({x = x, y = pos.y, z = z}, {name = ("loria:" .. gas), param2 = gas_levels})
      end
    end
    return minetest.chat_send_player(name, "Done")
  end
end
minetest.register_chatcommand("chemical_attack", {description = "Sends gas", func = _17_, params = "<gas>", privs = {}})
local fill_radius = 10
local function _19_(name, nodename)
  local player = minetest.get_player_by_name(name)
  if (nodename and player and minetest.registered_nodes[nodename]) then
    local pos = player:get_pos()
    for x = (pos.x - fill_radius), (pos.x + fill_radius) do
      for z = (pos.z - fill_radius), (pos.z + fill_radius) do
        minetest.set_node({x = x, y = (pos.y - 1), z = z}, {name = nodename})
      end
    end
    return minetest.chat_send_player(name, "Done")
  end
end
minetest.register_chatcommand("fill", {description = string.format("Fill %d\194\160\195\151 %d square", fill_radius, fill_radius), func = _19_, params = "<nodename>", privs = {}})
local function _21_(name, node)
  return minetest.chat_send_player(name, tostring(minetest.get_content_id(node)))
end
minetest.register_chatcommand("cid", {description = "Returns content id.", func = _21_, params = "<node>", privs = {}})
local function _22_(pos)
  local pos_e2_80_b2 = above(pos)
  if ((minetest.get_node(pos_e2_80_b2)).name == "air") then
    return minetest.set_node(pos_e2_80_b2, {name = "loria:chlorine", param2 = gas_levels})
  end
end
minetest.register_abm({action = _22_, chance = 1, interval = 1, label = "Chlorine source", nodenames = {"loria:test"}})
local function _24_(pos)
  local vects = {vector.new(0, 1, 0), vector.new(1, 0, 0), vector.new(-1, 0, 0), vector.new(0, 0, 1), vector.new(0, 0, -1)}
  for _, vect in ipairs(vects) do
    local v = vector.add(pos, vect)
    if (minetest.get_node(v).name == "air") then
      minetest.set_node(v, {name = "loria:oxygen", param2 = gas_levels})
    end
  end
  return nil
end
return minetest.register_abm({action = _24_, chance = 1, interval = 1, label = "Oxygen source", nodenames = {"loria:infinite_oxygen"}})
