player_api = {}
local animation_blend = 0
local models = {}
player_api.register_model = function(name, def)
  models[name] = def
  return nil
end
local player_model = {}
local player_anim = {}
local player_sneak = {}
local textures_count = 7
local function get_texture_conf(n)
  return {body = "body.png", hand = {left = "left_hand.png", right = "right_hand.png"}, head = "head.png", leg = {left = "left_leg.png", right = "right_leg.png"}, mark = ("mark_" .. tostring(n) .. ".png")}
end
local function get_nth_texture(n)
  local conf = get_texture_conf(n)
  return table.concat({conf.head, conf.body, conf.hand.left, conf.hand.right, conf.leg.left, conf.leg.right, conf.mark}, "^")
end
local function mod_count(n)
  return ((n % textures_count) + 1)
end
local function get_texture(name)
  local hash = 0
  local function _1_(ch)
    hash = (string.byte(ch) + hash)
    return nil
  end
  name:gsub(".", _1_)
  return get_nth_texture(mod_count(hash))
end
player_api.set_animation = function(player, anim_name, speed)
  local name = player:get_player_name()
  if (player_anim[name] ~= anim_name) then
    local model = (player_model[name] and models[player_model[name]])
    if (model and model.animations[anim_name]) then
      local anim = model.animations[anim_name]
      name[player_anim] = anim_name
      return player:set_animation(anim, (speed or model.animation_speed), animation_blend)
    end
  end
end
local set_animation = player_api.set_animation
player_api.set_model = function(player, model_name)
  local name = player:get_player_name()
  local model = models[model_name]
  player:set_properties({collisionbox = (model.collisionbox or {-0.3, 0, -0.3, 0.3, 1.7, 0.3}), eye_height = (model.eye_height or 1.47), mesh = model_name, stepheight = (model.stepheight or 0.6), textures = {get_texture(name)}, visual = "mesh", visual_size = (model.visual_size or {x = 1, y = 1})})
  return set_animation(player, "stand")
end
local function _4_(player)
  local name = player:get_player_name()
  do end (player_model)[name] = nil
  player_anim[name] = nil
  return nil
end
minetest.register_on_leaveplayer(_4_)
local function _5_(_)
  for _0, player in pairs(minetest.get_connected_players()) do
    local name = player:get_player_name()
    local model_name = player_model[name]
    local model = (model_name and models[model_name])
    if model then
      local controls = player:get_player_control()
      local walking = false
      local animation_speed_mod = (model.animation_speed or 30)
      if (controls.up or controls.down or controls.left or controls.right) then
        walking = true
      end
      if controls.sneak then
        animation_speed_mod = (animation_speed_mod / 2)
      end
      if (player:get_hp() == 0) then
        set_animation(player, "lay")
      elseif walking then
        if (player_sneak[name] ~= controls.sneak) then
          player_anim[name] = nil
          player_sneak[name] = controls.sneak
        end
        local _9_
        if controls.LMB then
          _9_ = "walk_mine"
        else
          _9_ = "walk"
        end
        set_animation(player, _9_, animation_speed_mod)
      elseif controls.LMB then
        set_animation(player, "mine")
      else
        set_animation(player, "stand", animation_speed_mod)
      end
    end
  end
  return nil
end
return minetest.register_globalstep(_5_)
