local function get_tint_img(color)
  return string.format("blind.png^[colorize:%s:255^[opacity:%d", minetest.rgba(color.r, color.g, color.b), color.a)
end
local function get_or_default(meta, key, default)
  if meta:contains(key) then
    return meta:get_string(key)
  else
    return default
  end
end
local function _2_(player, color)
  local meta = player:get_meta()
  local screen_tint = meta:get_int("tint")
  local img = get_tint_img(color)
  meta:set_string("tint-image", img)
  return player:hud_change(screen_tint, "text", img)
end
tint = _2_
transparent = {a = 0, b = 255, g = 255, r = 255}
local function _3_(player)
  local meta = player:get_meta()
  local img = get_or_default(meta, "tint-image", get_tint_img(transparent))
  return meta:set_int("tint", player:hud_add({hud_elem_type = "image", position = {x = 0.5, y = 0.5}, scale = {x = -101, y = -101}, text = img}))
end
return minetest.register_on_joinplayer(_3_)
