-- Copyright (C) 2025  snoutie
-- Authors: snoutie (copyright@achtarmig.org)
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as published
-- by the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <https://www.gnu.org/licenses/>.

local modpath = core.get_modpath(core.get_current_modname())

liquid_physics = {}

dofile(modpath .. "/api.lua")

if core.get_modpath("default") then
    liquid_physics.register_liquid("default", "water_source", "water_flowing")
    liquid_physics.register_liquid("default", "lava_source", "lava_flowing")
end

if core.get_modpath("mcl_core") then
    liquid_physics.register_liquid("mcl_core", "water_source", "water_flowing")
    liquid_physics.register_liquid("mcl_core", "lava_source", "lava_flowing")
end

dofile(modpath .. "/physics.lua")
