minetest.register_node("gravel_a:gravel", {
	description = ("Gravel"),
	tiles = {"gravel.png"},
	groups = {crumbly = 2, falling_node = 1},
	sounds = default.node_sound_gravel_defaults(),
	drop = {
		max_items = 1,
		items = {
			{items = {"default:flint"}, rarity = 16},
			{items = {"gravel_a:gravel"}}
		}
	}
})
minetest.register_node("gravel_a:alternate_gravel", {
	description = ("Alternate Gravel"),
	tiles = {"gravel_alternate.png"},
	groups = {crumbly = 2, falling_node = 1},
	sounds = default.node_sound_gravel_defaults(),
	drop = {
		max_items = 1,
		items = {
			{items = {"default:flint"}, rarity = 16},
			{items = {"gravel_a:alternate_gravel"}}
		}
	}
})

minetest.register_ore({
		ore_type        = "blob",
		ore             = "gravel_a:gravel",
		wherein         = {"default:stone"},
		clust_scarcity  = 25 * 25 * 25,
		clust_size      = 5,
		y_max           = 50,
		y_min           = -3000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 766,
			octaves = 1,
			persist = 0.0
		},
	})
	minetest.register_ore({
		ore_type        = "blob",
		ore             = "gravel_a:alternate_gravel",
		wherein         = {"default:stone"},
		clust_scarcity  = 20 * 20 * 20,
		clust_size      = 5,
		y_max           = 50,
		y_min           = -3500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
				seed = 766,
			octaves = 1,
			persist = 0.0
		},
	})

