#####################################################################
#
# only allow administrator access (by username or IP address)
#
#####################################################################

pass any
if $addr eq 172.16.100.1
if $addr eq 172.16.100.2
if $name eq "admin"
continue

fail now

#####################################################################
#
# block access from a range of IP addresses
#
#####################################################################

try "This subnet is blocked by the administrator."

fail any
if $addr is /192.88.99.6</a
if $addr is /203.0.113.?/a
if $addr is /192.168.12^14.?/a
continue

pass now

#####################################################################
#
# only allow access from whitelisted players
#
#####################################################################

try "The account '$name' is not permitted to join this server."

when $name in @whitelist.txt pass

fall now

#####################################################################
#
# never allow access from blacklisted players
#
#####################################################################

try "The account '$name' is not permitted to join this server."

when $name in @blacklist.txt fail

pass now

#####################################################################
#
# notify players that the server is unavailable right now
#
#####################################################################

try "The server is temporarily offline for maintenance."

fail now

#####################################################################
#
# disallow players with all uppercase names
#
#####################################################################

try "Sorry, we do not accept all uppercase player names."

when $name eq uc($name) fail

pass now

#####################################################################
#
# disallow players with very short or very long names
#
#####################################################################

try "Sorry, this player name is too long or too short."

fail any
if $name->len() gt 20
if $name->len() lt 3
continue

pass now

#####################################################################
#
# disallow users that appear to be bots or guests
#
#####################################################################

try "Sorry, we do not accept autogenerated player names."

fail any
if $name is /;*;*##/
if $name is /;*;*###/
if $name is /Player#/
if $name is /Player##/
if $name is /Guest#/
if $name is /Guest##/
continue

pass now

#####################################################################
#
# disallow new players when the server is near capacity
#
#####################################################################

try "There are too many players online right now."

fail all
if $is_new eq $true
if $cur_users gte $max_users->mul(0.8)
continue

pass now

#####################################################################
#
# prevent players from joining with a reserved name
#
#####################################################################

try "Sorry, this acccount has been permanently restricted."

fail all
if $is_new eq $true
if ("moderator","server","client","owner","player","system","operator","minetest") has $name
continue

pass now

#####################################################################
#
# disallow players that have been inactive for 90 days
#
#####################################################################

try "Sorry, this acccount has been disabled for inactivity."

fail all
if $is_new eq $false
if age($newlogin) gt 90d
continue

pass now

#####################################################################
#
# disallow new players during the weekends
#
#####################################################################

try "Sorry, we are not accepting new players at this time."

fail now
if $is_new eq $true
if $clock->day() in ("Sat","Sun")
continue

pass now

#####################################################################
#
# prevent players from spam-logging the server
#
#####################################################################

try "You are doing that too much. Please wait awhile."

fail all
if $is_new eq $false
if age($newlogin) lt 15s
continue

pass now
