#####################################################################
#
# only allow administrator access (by username or IP address)
#
#####################################################################

pass any
if $addr eq "172.16.100.1"
if $addr eq "172.16.100.2"
if $name eq "admin"
continue

fail now

#####################################################################
#
# block a range of IP addresses using wildcards
#
#####################################################################

try "This subnet is blocked by the administrator."

fail any
if $addr is /192.88.99.*/
if $addr is /203.0.113.*/
if $addr is /192.168.*.*/
continue

pass now

#####################################################################
#
# only allow access from whitelisted players
#
#####################################################################

try "The account '$name' is not permitted to join this server."

pass any
if $name eq "admin"
when @whitelist.txt eq $name
continue

fall now

#####################################################################
#
# never allow access from blacklisted players
#
#####################################################################

try "The account '$name' is not permitted to join this server."
fail all
when @blacklist.txt eq $name
continue

pass now

#####################################################################
#
# notify players that the server is unavailable right now
#
#####################################################################

try "The server is temporarily offline for maintenance."

fail now

#####################################################################
#
# disallow players with all uppercase names
#
#####################################################################

try "Sorry, we do not accept all uppercase player names."

fail all
$name eq uc($name)
continue

pass now

#####################################################################
#
# disallow players with very short or very long names
#
#####################################################################

try "Sorry, this player name is too long or too short."

fail any
$name->len() gt 20
$name->len() lt 3
continue

pass now

#####################################################################
#
# disallow users that appear to be bots or guests
#
#####################################################################

try "Sorry, we do not accept autogenerated player names."

fail any
if $name is /;*;*##/
if $name is /;*;*###/
if $name is /Player#/
if $name is /Player##/
if $name is /Guest#/
if $name is /Guest##/
continue

pass now

#####################################################################
#
# disallow new players when the server is near capacity
#
#####################################################################

try "There are too many players online right now."

fail all
$is_new eq $true
$cur_users gte $max_users->mul(0.8)
continue

pass now

#####################################################################
#
# prevent players from joining with a reserved name
#
#####################################################################

try "Sorry, this acccount has been permanently restricted."

fail all
$is_new eq $true
when ("moderator","server","client","owner","player","system","operator","minetest") is $name
continue

pass now

#####################################################################
#
# disallow players that have been inactive for 90 days
#
#####################################################################

try "Sorry, this acccount has been disabled for inactivity."

fail all
if $is_new eq $false
if age($newlogin) gt 90d
continue

pass now

#####################################################################
#
# disallow new players during the weekends
#
#####################################################################

try "Sorry, we are not accepting new players at this time."

fail now
if $is_new eq $true
when ("Sat","Sun") eq $clock->day()
continue

pass now

#####################################################################
#
# prevent players from spam-logging the server
#
#####################################################################

try "You are doing that too much. Please wait awhile."

fail all
if $is_new eq $false
if age($newlogin) lt 15s
continue

pass now
