--------------------------------------------------------
-- Minetest :: Basic Ownership v1.1 (ownership)
--
-- See README.txt for licensing and other information.
-- Copyright (c) 2016-2020, Leslie E. Krause
--
-- ./games/minetest_game/mods/ownership/init.lua
--------------------------------------------------------

default.OWNER_ANYBODY = "_anybody"
default.OWNER_SOMEBODY = "_somebody"
default.OWNER_NOBODY = ""

-----------------------------------------------------------------
-- register privilege for admins to override access controls
-----------------------------------------------------------------

minetest.register_privilege( "superuser", {
        description = "Bypass ownership and protection checks.",
        give_to_singleplayer = true
})

default.is_superuser = function( name )
	return minetest.check_player_privs( name, { superuser = true } )
end

-----------------------------------------------------------------
-- prohibit players from joining with special names
-----------------------------------------------------------------

minetest.register_on_prejoinplayer( function ( name, ip )
	local uname = string.lower( name )
	if uname == default.OWNER_ANYBODY or uname == default.OWNER_SOMEBODY or uname == default.OWNER_NOBODY or string.byte( uname ) == 95 then
		return "This player name is reserved and cannot be used."
	end
end )

-----------------------------------------------------------------
-- verify player's ownership of node at given position
-- allow for customized methods by abstracting node meta
-----------------------------------------------------------------

default.set_owner = function ( pos, player_name )
	minetest.get_meta( pos ):set_string( "owner", player_name )
end

default.is_owner = function ( pos, player_name )
	local owner_name = minetest.get_meta( pos ):get_string( "owner" )

	--core.chat_send_player( name, "This area belongs to " .. owner .. "." )
	return minetest.check_player_privs( player_name, { superuser = true } ) or 
		owner_name == default.OWNER_ANYBODY or owner_name == default.OWNER_NOBODY or owner_name == player_name
end
