local S = digilines.S
local FS = digilines.FS

minetest.register_node("digichat:digichat", {
    description = "Digichat Block",
    tiles = {"digichat_top.png", "digichat_sides.png", "digichat_sides.png"},
    groups = {crumbly = 3},
    paramtype2 = "facedir",
    is_ground_content = false,

    digilines = {
        effector = {
            action = function(pos, _, channel, msg)
	            local meta = minetest.get_meta(pos)
	            local setchan = meta:get_string("channel")
                local setname = meta:get_string("name")
	            if setchan ~= channel then return end
                if string.match(setname, "%S") == nil then 
                    setname = setchan
                end
                minetest.chat_send_all("[" .. setname .. "] " .. msg)
            end,
        },
    },

    on_construct = function(pos)
		minetest.get_meta(pos):set_string("formspec", "size[8.01,2.28]\nfield[0.4,0.57;7.8,0.87;channel;Channel;${channel}]\nfield[0.4,1.87;7.8,0.87;name;Name;${name}]\n")
    end,

    _digistuff_channelcopier_fieldname = "channel",

    on_receive_fields = function(pos, formname, fields, sender)
		if minetest.is_protected(pos, sender:get_player_name()) then return end
		if fields.channel then
			minetest.get_meta(pos):set_string("channel", fields.channel)
		end
        if fields.name then
			minetest.get_meta(pos):set_string("name", fields.name)
		end
	end,
})

minetest.register_craft({
    output = "digichat:digichat",
    recipe = {
        {"default:steel_ingot", "default:mese_crystal", "default:steel_ingot"},
        {"default:mese_crystal", "default:copper_block", "default:mese_crystal"},
        {"default:steel_ingot", "default:mese_crystal", "default:steel_ingot"},
    }
})
