local path = minetest.get_modpath("mortar")

function normalize_vector(v)
    local magnitude = vector.length(v)  -- Get the magnitude (length) of the vector
    if magnitude == 0 then
        return {x = 0, y = 0, z = 0}  -- Return a zero vector if the magnitude is zero (avoid division by zero)
    end
    return vector.multiply(v, 1 / magnitude)  -- Scale the vector to have magnitude 1
end

conduct = false
dofile(path.."/cannon.lua")
dofile(path.."/bomb.lua")

dofile(path.."/craft.lua")
