bypass_protection = true

local function remove_nodes(pos, radius, disable_drop_nodes)
    if not disable_drop_nodes then disable_drop_nodes = false end
    local pr = PseudoRandom(os.time())
    for z = -radius, radius do
        for y = -radius, radius do
            for x = -radius, radius do
                -- remove the nodes
                local r = vector.length(vector.new(x, y, z))
                if (radius * radius) / (r * r) >= (pr:next(80, 125) / 100) then
                    local p = {x = pos.x + x, y = pos.y + y, z = pos.z + z}
                    
	                local node = minetest.get_node(p).name
	                local nodedef = minetest.registered_nodes[node]
	                local is_liquid = nodedef.liquidtype ~= "none"
                    local is_leaf = (nodedef.drawtype == "plantlike") or (nodedef.drawtype == "allfaces_optional")

                    if is_leaf then
                        minetest.set_node(p, {name = "fire:basic_flame"})
                    elseif not is_liquid then
                        minetest.remove_node(p)
                    end
                end
            end
        end
    end


    if disable_drop_nodes == false then
        local radius = radius
        for z = -radius, radius do
            for y = -radius, radius do
                for x = -radius, radius do
                    -- do fancy stuff
                    local r = vector.length(vector.new(x, y, z))
                    if (radius * radius) / (r * r) >= (pr:next(80, 125) / 100) then
                        local p = {x = pos.x + x, y = pos.y + y, z = pos.z + z}
                        minetest.spawn_falling_node(p)
                    end
                end
            end
        end
    end
end


-- thank u air utils

function nodeatpos(pos)
    if pos == nil then return end
	local node = minetest.get_node_or_nil(pos)
	if node then return minetest.registered_nodes[node.name] end
end

function add_destruction_effects(pos, radius, w_fire)
    if pos == nil then return end
    w_fire = w_fire
    if w_fire == nil then w_fire = true end
	local node = nodeatpos(pos)
    local is_liquid = false
    if (node.drawtype == 'liquid' or node.drawtype == 'flowingliquid') then is_liquid = true end

    minetest.sound_play("explode", {
        pos = pos,
        max_hear_distance = 100,
        gain = 2.0,
        fade = 0.0,
        pitch = 1.0,
    }, true)
    if is_liquid == false and w_fire == true then
	    minetest.add_particle({
		    pos = pos,
		    velocity = vector.new(),
		    acceleration = vector.new(),
		    expirationtime = 0.4,
		    size = radius * 10,
		    collisiondetection = false,
		    vertical = false,
		    texture = "boom.png",
		    glow = 15,
	    })
	    minetest.add_particlespawner({
		    amount = 32,
		    time = 0.5,
		    minpos = vector.subtract(pos, radius / 2),
		    maxpos = vector.add(pos, radius / 2),
		    minvel = {x = -10, y = -10, z = -10},
		    maxvel = {x = 10, y = 10, z = 10},
		    minacc = vector.new(),
		    maxacc = vector.new(),
		    minexptime = 1,
		    maxexptime = 2.5,
		    minsize = radius * 3,
		    maxsize = radius * 5,
		    texture = "boom.png",
	    })
    end
	minetest.add_particlespawner({
		amount = 64,
		time = 1.0,
		minpos = vector.subtract(pos, radius / 2),
		maxpos = vector.add(pos, radius / 2),
		minvel = {x = -10, y = -10, z = -10},
		maxvel = {x = 10, y = 10, z = 10},
		minacc = vector.new(),
		maxacc = vector.new(),
		minexptime = 1,
		maxexptime = 2.5,
		minsize = radius * 3,
		maxsize = radius * 5,
		texture = "smoke.png",
	})
end

function add_blast_damage(pos, radius, damage_cal)
    if not pos then return end
    radius = radius or 10
    damage_cal = damage_cal or 4

    local objs = minetest.get_objects_inside_radius(pos, radius)
	for _, obj in pairs(objs) do
		local obj_pos = obj:get_pos()
		local dist = math.max(1, vector.distance(pos, obj_pos))
        local damage = (damage_cal / dist) * radius

        if obj:is_player() then
            obj:set_hp(obj:get_hp() - damage)
        else
            local luaobj = obj:get_luaentity()

            -- object might have disappeared somehow
            if luaobj then
				local do_damage = true
				local do_knockback = true
				local entity_drops = {}
				local objdef = minetest.registered_entities[luaobj.name]

				if objdef and objdef.on_blast then
					do_damage, do_knockback, entity_drops = objdef.on_blast(luaobj, damage)
				end

				if do_knockback then
					local obj_vel = obj:get_velocity()
				end
				if do_damage then
                    obj:punch(obj, 1.0, {
                        full_punch_interval = 1.0,
                        damage_groups = {fleshy = damage},
                    }, nil)
				end
				--[[for _, item in pairs(entity_drops) do
					add_drop(drops, item) -- !!! accessing undefined variable add_drop, drops
				end]]--
			end

        end
    end
    --lets light some bombs
    local pr = PseudoRandom(os.time())
    for z = -radius, radius do
        for y = -radius, radius do
            for x = -radius, radius do
                -- remove the nodes
                local r = vector.length(vector.new(x, y, z))
                if (radius * radius) / (r * r) >= (pr:next(80, 125) / 100) then
                    local p = {x = pos.x + x, y = pos.y + y, z = pos.z + z}
	                local node = minetest.get_node(p).name
                    if node == "tnt:tnt" then minetest.set_node(p, {name = "tnt:tnt_burning"}) end
                end
            end
        end
    end

end

local function explode(object, radius)
    local pos = object:get_pos()

    add_destruction_effects(pos,radius,true)

    -- remove nodes
    local ent = object:get_luaentity()
    if bypass_protection == false then
        local name = ""
        if ent.shooter_name then
            name = ent.shooter_name
        end

        if minetest.is_protected(pos, name) == false then
            remove_nodes(pos, radius)
        end
    else
        remove_nodes(pos, radius)
    end

    --damage entites/players
    add_blast_damage(pos, radius+6, 50)

    object:remove()
end

function dir_to_rot(v,rot)
	rot = rot or {x=0,y=0,z=0}
	return {x = (v.x==0 and v.y==0 and v.z==0) and rot.x or math.atan2(v.y,vector.length({x=v.x,y=0,z=v.z})),
			y = (v.x==0 and v.z==0) and rot.y or minetest.dir_to_yaw(v),
			z=rot.z}
end

local function register_bomb(radius, ent_name,inv_img, bomb_obj, description, bomb_max_stack) 
    local one_step = false
    bomb_max_stack = bomb_max_stack or 99
    minetest.register_entity(ent_name, {   
        initial_properties = {
            physical = true,
            visual = "mesh",
            mesh = bomb_obj,
            textures = {"default_steel_block.png"},
            backface_culling = false,
            visual_size = {x = 0.05, y = 0.05, z = 0.05},
            collisionbox = {-.5, -.5, -.25, .5, .5, .25},
            pointable = false,
            static_save = false,
        },
        bomb_radius = radius,
        on_step = function(self,var,moveresult)
            local obj = self.object
            velocity = obj:get_velocity()
            dir = normalize_vector(velocity)
            rot = dir_to_rot(dir)
            rot.x = rot.x - rad(90)
            obj:set_rotation(rot)
            obj:set_acceleration({x=0,y=-9.8,z=0})
            if moveresult.collides and moveresult.collisions then
                explode(obj, self.bomb_radius)
            end
        end,
    })
    minetest.register_craftitem(ent_name,{
        description = description,
        stack_max = bomb_max_stack,
        inventory_image = inv_img,
    })
end

register_bomb(4,"mortar:bomb","mortar_bomb.png","mortar_projectile.obj","cannon bomb",5)