minetest.register_node("blobcats:blobcat1", {
	description = "Blobcat Node 1",
	light_source = 3,
	tiles = {"blobcat_block1.png"},
	groups = {choppy=1},
	on_use = minetest.item_eat(20)
})

minetest.register_node("blobcats:blobcat2", {
	description = "Blobcat Node 2",
	light_source = 3,
	tiles = {"blobcat_block2.png"},
	groups = {choppy=1},
	on_use = minetest.item_eat(20)
})

minetest.register_abm({
	nodenames = {"default:dirt_with_grass", "default:dirt", "default:snow", "default:sand"},
	--neighbors = {"default:water_source", "default:water_flowing"},
	interval = 120.0,
	chance = 3,
	action = function(pos, node, active_object_count, active_object_count_wider)
		minetest.set_node({x = pos.x, y = pos.y + 1, z = pos.z}, {name = "blobcats:blobcat1"})
	end
})

minetest.register_abm({
	nodenames = {"default:sand", "default:snow", "default:dirt", "default:dirt_with_grass"},
	--neighbors = {"default:water_source", "default:water_flowing"},
	interval = 120.0,
	chance = 3,
	action = function(pos, node, active_object_count, active_object_count_wider)
		minetest.set_node({x = pos.x, y = pos.y + 1, z = pos.z}, {name = "blobcats:blobcat2"})
	end
})