local train_def = {
	craft = {
		output = "subways_mpl16:mpl16",
		recipe = {
			{"", "subways_mpl16:mpl16_body", ""},
			{"subways:scharfenberg_coupler", "subways:chassis", ""},
			{"subways:bogie", "subways:drive_unit", "subways:bogie"},
		},
	},
	body = {
		craftitem = {
			name = "subways_mpl16:mpl16_body",
			description = "MPL16 Body",
			inventory_image = "mpl16_body.png",
		},
		craft_recipe = {
			output = "subways_mpl16:mpl16_body",
			recipe = {
				{"default:steelblock", "default:steel_ingot", "default:steelblock"},
				{"xpanes:pane_flat", "subways:blueprint", "xpanes:pane_flat"},
				{"dye:red", "dye:white", "dye:black"},
			},
		},
	},
	displays = {
		{
			background_size = 120,
			display = "outside_first_line",
			offset = {x = 16, y = 8},
			slot = 2,
		},
		{
			background_size = 140,
			display = "outside_first_line",
			offset = {x = 16, y = 7},
			slot = 3,
		},
	},
	livery_def = {
		livery_template = {
			name = "MPL16",
			designer = "Sam Matzko",
			texture_license = "CC-BY-SA-3.0",
			texture_creator = "Sam Matzko",
			notes = "Color overrides for exterior accents.",
			base_textures = {
				"mpl16.png",
			},
			overlays = {
				[1] = {name = "Primary Exterior Accents", slot_idx = 1, texture = "mpl16_livery.png", alpha = 255},
			},
		},
		predefined_livery = {
			name = "Standard Red",
			notes = "The default red color scheme.",
			livery_design = {
				livery_template_name = "MPL16",
				overlays = {
					[1] = {id = 1, color = "#ff0000"},
				},
			},
		},
	},
	wagon_def = {
		mesh = "mpl16.b3d",
		textures = {
			"mpl16.png",
			"subways_displays.png",
			"subways_displays.png",
		},
		base_texture = "mpl16.png",
		base_texture_size = 512,
		light_texture_backwards = "mpl16_backwards.png",
		light_texture_forwards = "mpl16_forwards.png",
		light_texture_pos = {x = 0, y = 0},
		drives_on = {default = true},
		max_speed = 15,
		seats = {
			{
				name = "driver_stand",
				attach_offset = {x = 0, y = 4, z = 28},
				view_offset = {x = 0, y = 0, z = 0},
				group = "driver_stand",
			},
			{
				name = "1",
				attach_offset = {x = -5, y = 4, z = 1},
				view_offset = {x = 0, y = 0, z = 0},
				group = "passenger",
			},
			{
				name = "2",
				attach_offset = {x = 5, y = 4, z = 1},
				view_offset = {x = 0, y = 0, z = 0},
				group = "passenger",
			},
			{
				name = "3",
				attach_offset = {x = -5, y = 4, z = 25},
				view_offset = {x = 0, y = 0, z = 0},
				group = "passenger",
			},
			{
				name = "4",
				attach_offset = {x = 5, y = 4, z = 25},
				view_offset = {x = 0, y = 0, z = 0},
				group = "passenger",
			},
			{
				name = "5",
				attach_offset = {x = -5, y = 4, z = -6},
				view_offset = {x = 0, y = 0, z = 0},
				group = "passenger",
			},
			{
				name = "6",
				attach_offset = {x = 5, y = 4, z = -6},
				view_offset = {x = 0, y = 0, z = 0},
				group = "passenger",
			},
			{
				name = "7",
				attach_offset = {x = -5, y = 4, z = -29},
				view_offset = {x = 0, y = 0, z = 0},
				group = "passenger",
			},
			{
				name = "8",
				attach_offset = {x = 5, y = 4, z = -29},
				view_offset = {x = 0, y = 0, z = 0},
				group = "passenger",
			},
		},
		seat_groups = {
			driver_stand = {
				name = "Driver Stand",
				access_to = {"passenger"},
				require_doors_open = true,
				driving_ctrl_access = true,
			},
			passenger = {
				name = "Passenger",
				access_to = {"driver_stand"},
				require_doors_open = true,
				driving_ctrl_access = false,
			},
		},
		door_entry = {1.5, -1.5},
		coupler_types_back = {mpl16 = true},
		coupler_types_front = {scharfenberg = true},
		assign_to_seat_group = {"passenger", "driver_stand"},
		is_locomotive = true,
		wagon_span = 3.6,
		wheel_positions = {2.1, -2.3},
		collisionbox = {
			-1.0, -0.5, -1.0,
			1.0, 2.5, 1.0,
		},
	},
}

subways.register_subway("mpl16", train_def, "MPL16", "mpl16_inv.png")
