-- The coupler to join the various parts together
advtrains.register_coupler_type("_13000_class_lead", "13000 Class Lead")
advtrains.register_coupler_type("_13000_class_intermediate", "13000 Class Intermediate")

local train_def = {
	craft = {
		output = "subways_13000_class_lead:13000_class_lead",
		recipe = {
			{"", "subways_13000_class:13000_class_lead_body", ""},
			{"", "subways:chassis", ""},
			{"subways:bogie", "subways:drive_unit", "subways:bogie"},
		},
	},
	body = {
		craftitem = {
			name = "subways_13000_class:13000_class_lead_body",
			description = "13000 Class Lead Car Body",
			inventory_image = "13000_class_lead_body.png",
		},
		craft_recipe = {
			output = "subways_13000_class:13000_class_lead_body",
			recipe = {
				{"default:steelblock", "default:steel_ingot", "default:steelblock"},
				{"xpanes:pane_flat", "subways:blueprint", "xpanes:pane_flat"},
				{"dye:grey", "dye:red", "dye:grey"},
			},
		},
	},
	displays = {
		{
			background_size = 150,
			display = "outside_first_line",
			offset = {x = 0, y = 0},
			slot = 2,
		},
	},
	livery_def = {
		livery_template = {
			name = "13000 Class",
			designer = "Sam Matzko",
			texture_license = "CC-BY-SA-3.0",
			texture_creator = "Sam Matzko",
			notes = "Color overrides for exterior accents.",
			base_textures = {
				"13000_class_lead.png",
			},
			overlays = {
				[1] = {name = "Exterior Accents", slot_idx = 1, texture = "13000_class_lead_livery.png", alpha = 255},
			},
		},
		predefined_livery = {
			name = "Standard Red",
			notes = "The default red color scheme.",
			livery_design = {
				livery_template_name = "13000 Class",
				overlays = {
					[1] = {id = 1, color = "#ff0000"},
				},
			},
		},
	},
	wagon_def = {
		mesh = "13000_class_lead.glb",
		textures = {
			"13000_class_lead.png",
			"subways_displays.png",
		},
		base_texture = "13000_class_lead.png",
		base_texture_size = 512,
		light_texture_backwards = "13000_class_lead_backwards.png",
		light_texture_forwards = "13000_class_lead_forwards.png",
		light_texture_pos = {x = 0, y = 0},
		drives_on = {default = true},
		max_speed = 15,
		seats = {
			{
				name = "driver_stand",
				attach_offset = {x = 0, y = 2, z = 28},
				view_offset = {x = 0, y = -1, z = 0},
				group = "driver_stand",
			},
			{
				name = "1",
				attach_offset = {x = 5, y = 2.5, z = 4},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger",
			},
			{
				name = "2",
				attach_offset = {x = -5, y = 2.5, z = 4},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger",
			},
			{
				name = "3",
				attach_offset = {x = 5, y = 2.5, z = -3},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger",
			},
			{
				name = "4",
				attach_offset = {x = -5, y = 2.5, z = -3},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger",
			},
			{
				name = "5",
				attach_offset = {x = 5, y = 2.5, z = -10},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger",
			},
			{
				name = "6",
				attach_offset = {x = -5, y = 2.5, z = -10},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger",
			},
			{
				name = "7",
				attach_offset = {x = 5, y = 2.5, z = -29},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger",
			},
			{
				name = "8",
				attach_offset = {x = -5, y = 2.5, z = -29},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger",
			},
		},
		seat_groups = {
			driver_stand = {
				name = "Driver Stand",
				access_to = {"passenger"},
				require_doors_open = true,
				driving_ctrl_access = true,
			},
			passenger = {
				name = "Passenger",
				access_to = {"driver_stand"},
				require_doors_open = true,
				driving_ctrl_access = false,
			},
		},
		door_entry = {0, 0},
		coupler_types_back = {_13000_class_lead = true},
		coupler_types_front = {},
		assign_to_seat_group = {"passenger", "driver_stand"},
		is_locomotive = true,
		wagon_span = 3.593,
		wheel_positions = {1, -1},
		collisionbox = {
			-1.0, -0.5, -1.0,
			1.0, 2.5, 1.0,
		},
	},
}

local train_intermediate_def = {
	craft = {
		output = "subways_13000_class_intermediate:13000_class_intermediate",
		recipe = {
			{"", "subways_13000_class:13000_class_intermediate_body", ""},
			{"", "subways:chassis", ""},
			{"subways:bogie", "subways:drive_unit", "subways:bogie"},
		},
	},
	body = {
		craftitem = {
			name = "subways_13000_class:13000_class_intermediate_body",
			description = "13000 Class Intermediate Car Body",
			inventory_image = "13000_class_intermediate_body.png",
		},
		craft_recipe = {
			output = "subways_13000_class:13000_class_intermediate_body",
			recipe = {
				{"default:steelblock", "", "default:steelblock"},
				{"xpanes:pane_flat", "subways:blueprint", "xpanes:pane_flat"},
				{"dye:grey", "dye:red", "dye:grey"},
			},
		},
	},
	displays = {
		{
			background_size = 150,
			display = "outside_first_line",
			offset = {x = 0, y = 0},
			slot = 2,
		},
	},
	livery_def = {
		livery_template = {
			name = "13000 Class",
			designer = "Sam Matzko",
			texture_license = "CC-BY-SA-3.0",
			texture_creator = "Sam Matzko",
			notes = "Color overrides for exterior accents.",
			base_textures = {
				"13000_class_intermediate.png",
			},
			overlays = {
				[1] = {name = "Exterior Accents", slot_idx = 1, texture = "13000_class_intermediate_livery.png", alpha = 255},
			},
		},
		predefined_livery = {
			name = "Standard Red",
			notes = "The default red color scheme.",
			livery_design = {
				livery_template_name = "13000 Class",
				overlays = {
					[1] = {id = 1, color = "#ff0000"},
				},
			},
		},
	},
	wagon_def = {
		mesh = "13000_class_intermediate.glb",
		textures = {
			"13000_class_intermediate.png",
			"subways_displays.png",
		},
		base_texture = "13000_class_intermediate.png",
		base_texture_size = 512,
		light_texture_backwards = "13000_class_intermediate_backwards.png",
		light_texture_forwards = "13000_class_intermediate_forwards.png",
		light_texture_pos = {x = 0, y = 0},
		drives_on = {default = true},
		max_speed = 15,
		seats = {
			{
				name = "1",
				attach_offset = {x = 5, y = 2.5, z = 4},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger",
			},
			{
				name = "2",
				attach_offset = {x = -5, y = 2.5, z = 4},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger",
			},
			{
				name = "3",
				attach_offset = {x = 5, y = 2.5, z = -3},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger",
			},
			{
				name = "4",
				attach_offset = {x = -5, y = 2.5, z = -3},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger",
			},
			{
				name = "5",
				attach_offset = {x = 5, y = 2.5, z = -10},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger",
			},
			{
				name = "6",
				attach_offset = {x = -5, y = 2.5, z = -10},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger",
			},
			{
				name = "7",
				attach_offset = {x = 5, y = 2.5, z = -29},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger",
			},
			{
				name = "8",
				attach_offset = {x = -5, y = 2.5, z = -29},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger",
			},
			{
				name = "9",
				attach_offset = {x = 5, y = 2.5, z = 24},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger",
			},
			{
				name = "10",
				attach_offset = {x = -5, y = 2.5, z = 24},
				view_offset = {x = 0, y = -1.5, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger",
			},
		},
		seat_groups = {
			passenger = {
				name = "Passenger",
				access_to = {},
				require_doors_open = true,
				driving_ctrl_access = false,
			},
		},
		door_entry = {0, 0},
		coupler_types_back = {_13000_class_lead = true},
		coupler_types_front = {_13000_class_intermediate = true},
		assign_to_seat_group = {"passenger"},
		is_locomotive = false,
		wagon_span = 3.593,
		wheel_positions = {1, -1},
		collisionbox = {
			-1.0, -0.5, -1.0,
			1.0, 2.5, 1.0,
		},
	},
}

subways.register_subway("13000_class_lead", train_def, "13000 Class Lead Car", "13000_class_lead_inv.png")
subways.register_subway("13000_class_intermediate", train_intermediate_def, "13000 Class Intermediate Car", "13000_class_intermediate_inv.png")

