-- The coupler to join the two halves together
advtrains.register_coupler_type("_30000_series", "30000 Series")

local train_def = {
	craft = {
		output = "subways_30000_series_lead:30000_series_lead",
		recipe = {
			{"", "subways_30000_series:30000_series_lead_body", ""},
			{"subways:shibata_coupler", "subways:chassis", ""},
			{"subways:bogie", "subways:drive_unit", "subways:bogie"},
		},
	},
	body = {
		craftitem = {
			name = "subways_30000_series:30000_series_lead_body",
			description = "30000 Series Lead Car Body",
			inventory_image = "30000_series_lead_body.png",
		},
		craft_recipe = {
			output = "subways_30000_series:30000_series_lead_body",
			recipe = {
				{"default:steelblock", "default:steel_ingot", "default:steelblock"},
				{"xpanes:pane_flat", "subways:blueprint", "xpanes:pane_flat"},
				{"dye:red", "dye:white", "dye:pink"},
			},
		},
	},
	displays = {
		{
			background_size = 120,
			display = "outside_first_line",
			offset = {x = 16, y = 7},
			slot = 2,
		},
		{
			background_size = 140,
			display = "outside_first_line",
			offset = {x = 16, y = 5},
			slot = 3,
		},
	},
	livery_def = {
		livery_template = {
			name = "30000 Series Lead",
			designer = "Sam Matzko",
			texture_license = "CC-BY-SA-3.0",
			texture_creator = "Sam Matzko",
			notes = "Color overrides for exterior accents.",
			base_textures = {
				"30000_series_lead.png",
			},
			overlays = {
				[1] = {name = "Primary Exterior Accents", slot_idx = 1, texture = "30000_series_lead_livery.png", alpha = 255},
				[2] = {name = "Secondary Exterior Accents", slot_idx = 1, texture = "30000_series_lead_livery_secondary.png", alpha = 255},
			},
		},
		predefined_livery = {
			name = "Standard Red",
			notes = "The default red color scheme.",
			livery_design = {
				livery_template_name = "30000 Series Lead",
				overlays = {
					[1] = {id = 1, color = "#ff0000"},
					[2] = {id = 2, color = "#ffa7a7"},
				},
			},
		},
	},
	wagon_def = {
		mesh = "30000_series_lead.glb",
		textures = {
			"30000_series_lead.png",
			"subways_displays.png",
			"subways_displays.png",
		},
		base_texture = "30000_series_lead.png",
		base_texture_size = 512,
		light_texture_backwards = "30000_series_backwards.png",
		light_texture_forwards = "30000_series_forwards.png",
		light_texture_pos = {x = 0, y = 0},
		drives_on = {default = true},
		max_speed = 15,
		seats = {
			{
				name = "driver_stand",
				attach_offset = {x = -4, y = 2, z = 28},
				view_offset = {x = 0, y = 0, z = 0},
				group = "driver_stand",
			},
			{
				name = "1",
				attach_offset = {x = 5, y = 2, z = 5},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger_front",
			},
			{
				name = "2",
				attach_offset = {x = -5, y = 2, z = 5},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger_front",
			},
			{
				name = "3",
				attach_offset = {x = 5, y = 2, z = -2},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger_front",
			},
			{
				name = "4",
				attach_offset = {x = -5, y = 2, z = -2},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger_front",
			},
			{
				name = "5",
				attach_offset = {x = 5, y = 2, z = -7},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger_front",
			},
			{
				name = "6",
				attach_offset = {x = -5, y = 2, z = -7},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger_front",
			},
			{
				name = "7",
				attach_offset = {x = 5, y = 2, z = -30},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger_rear",
			},
			{
				name = "8",
				attach_offset = {x = -5, y = 2, z = -30},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger_rear",
			},
		},
		seat_groups = {
			driver_stand = {
				name = "Driver Stand",
				access_to = {"passenger_front"},
				require_doors_open = true,
				driving_ctrl_access = true,
			},
			passenger_front = {
				name = "Passenger Front",
				access_to = {"driver_stand", "passenger_rear"},
				require_doors_open = true,
				driving_ctrl_access = false,
			},
			passenger_rear = {
				name = "Passenger Rear",
				access_to = {"passenger_front"},
				require_doors_open = true,
				driving_ctrl_access = false,
			},
		},
		door_entry = {2, -2},
		coupler_types_back = {_30000_series = true},
		coupler_types_front = {shibata = true},
		assign_to_seat_group = {"passenger_front", "passenger_rear", "driver_stand"},
		is_locomotive = true,
		wagon_span = 3.570,
		wheel_positions = {2.5, -2.5},
		collisionbox = {
			-1.0, -0.5, -1.0,
			1.0, 2.5, 1.0,
		},
	},
}

local train_intermediate_def = {
	craft = {
		output = "subways_30000_series_intermediate:30000_series_intermediate",
		recipe = {
			{"", "subways_30000_series:30000_series_intermediate_body", ""},
			{"", "subways:chassis", ""},
			{"subways:bogie", "subways:drive_unit", "subways:bogie"},
		},
	},
	body = {
		craftitem = {
			name = "subways_30000_series:30000_series_intermediate_body",
			description = "30000 Series Intermediate Car Body",
			inventory_image = "30000_series_intermediate_body.png",
		},
		craft_recipe = {
			output = "subways_30000_series:30000_series_intermediate_body",
			recipe = {
				{"default:steelblock", "", "default:steelblock"},
				{"xpanes:pane_flat", "subways:blueprint", "xpanes:pane_flat"},
				{"dye:red", "dye:white", "dye:pink"},
			},
		},
	},
	displays = {
		{
			background_size = 140,
			display = "outside_first_line",
			offset = {x = 16, y = 5},
			slot = 2,
		},
	},
	livery_def = {
		livery_template = {
			name = "30000 Series Intermediate",
			designer = "Sam Matzko",
			texture_license = "CC-BY-SA-3.0",
			texture_creator = "Sam Matzko",
			notes = "Color overrides for exterior accents.",
			base_textures = {
				"30000_series_intermediate.png",
			},
			overlays = {
				[1] = {name = "Primary Exterior Accents", slot_idx = 1, texture = "30000_series_intermediate_livery.png", alpha = 255},
				[2] = {name = "Secondary Exterior Accents", slot_idx = 1, texture = "30000_series_intermediate_livery_secondary.png", alpha = 255},
			},
		},
		predefined_livery = {
			name = "Standard Red",
			notes = "The default red color scheme.",
			livery_design = {
				livery_template_name = "30000 Series Intermediate",
				overlays = {
					[1] = {id = 1, color = "#ff0000"},
					[2] = {id = 2, color = "#ffa7a7"},
				},
			},
		},
	},
	wagon_def = {
		mesh = "30000_series_intermediate.glb",
		textures = {
			"30000_series_intermediate.png",
			"subways_displays.png",
			"subways_displays.png",
		},
		base_texture = "30000_series_intermediate.png",
		base_texture_size = 512,
		light_texture_backwards = "subways_displays.png",
		light_texture_forwards = "subways_displays.png",
		light_texture_pos = {x = 0, y = 0},
		drives_on = {default = true},
		max_speed = 15,
		seats = {
			{
				name = "1",
				attach_offset = {x = 5, y = 2, z = 0},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger_middle",
			},
			{
				name = "2",
				attach_offset = {x = -5, y = 2, z = 0},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger_middle",
			},
			{
				name = "3",
				attach_offset = {x = 5, y = 2, z = -6},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger_middle",
			},
			{
				name = "4",
				attach_offset = {x = -5, y = 2, z = -6},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger_middle",
			},
			{
				name = "5",
				attach_offset = {x = 5, y = 2, z = 6},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger_middle",
			},
			{
				name = "6",
				attach_offset = {x = -5, y = 2, z = 6},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger_middle",
			},
			{
				name = "7",
				attach_offset = {x = 5, y = 2, z = -28},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger_rear",
			},
			{
				name = "8",
				attach_offset = {x = -5, y = 2, z = -28},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger_rear",
			},
			{
				name = "9",
				attach_offset = {x = 5, y = 2, z = 28},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = -90, z = 0},
				group = "passenger_front",
			},
			{
				name = "10",
				attach_offset = {x = -5, y = 2, z = 28},
				view_offset = {x = 0, y = 0, z = 0},
				advtrains_attachment_offset_patch_attach_rotation = {x = 0, y = 90, z = 0},
				group = "passenger_front",
			},
		},
		seat_groups = {
			passenger_front = {
				name = "Passenger Front",
				access_to = {"passenger_middle"},
				require_doors_open = true,
				driving_ctrl_access = false,
			},
			passenger_middle = {
				name = "Passenger Middle",
				access_to = {"passenger_front", "passenger_rear"},
				require_doors_open = true,
				driving_ctrl_access = false,
			},
			passenger_rear = {
				name = "Passenger Rear",
				access_to = {"passenger_middle"},
				require_doors_open = true,
				driving_ctrl_access = false,
			},
		},
		door_entry = {2, -2},
		coupler_types_back = {_30000_series = true},
		coupler_types_front = {_30000_series = true},
		assign_to_seat_group = {"passenger_middle", "passenger_front", "passenger_rear"},
		is_locomotive = false,
		wagon_span = 3.450,
		wheel_positions = {2.5, -2.5},
		collisionbox = {
			-1.0, -0.5, -1.0,
			1.0, 2.5, 1.0,
		},
	},
}

subways.register_subway("30000_series_lead", train_def, "30000 Series Lead Car", "30000_series_lead_inv.png")
subways.register_subway("30000_series_intermediate", train_intermediate_def, "30000 Series Intermediate Car", "30000_series_intermediate_inv.png")
