draconis = {}

draconis.walkable_nodes = {}

draconis.dragon = nil

minetest.register_on_mods_loaded(function()
	for name in pairs(minetest.registered_nodes) do
		if name ~= "air" and name ~= "ignore" then
			if minetest.registered_nodes[name].walkable then
				table.insert(draconis.walkable_nodes, name)
			end
		end
	end
end)

function draconis.find_value_in_table(tbl, val)
    for _, v in ipairs(tbl) do
        if v == val then
            return true
        end
    end
    return false
end

local function all_first_to_upper(str)
	str = string.gsub(" "..str, "%W%l", string.upper):sub(2)
    return str
end

local function underscore_to_space(str)
    return (str:gsub("_", " "))
end

function draconis.string_format(str)
	if str then
		if str:match(":") then
			str = str:split(":")[2]
		end
		str = all_first_to_upper(str)
		str = underscore_to_space(str)
		return str
	end
end

local path = minetest.get_modpath("c_dragons")

dofile(path.."/api/api.lua")
dofile(path.."/api/hq_lq.lua")
dofile(path.."/mobs/purple_dragon.lua")
dofile(path.."/mobs/blue_dragon.lua")
dofile(path.."/mobs/black_dragon.lua")



minetest.log("action", "[MOD] Colourhop Draconis v1.0 loaded")
