
dofile(minetest.get_modpath("c_player_api") .. "/api.lua")

c_player_api.register_model("red.b3d", {
	animation_speed = 30,
	textures = {"player_red.png", "player_eyes.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

c_player_api.register_model("green.b3d", {
	animation_speed = 30,
	textures = {"player_green.png", "player_eyes.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

c_player_api.register_model("yellow.b3d", {
	animation_speed = 30,
	textures = {"player_yellow.png", "player_eyes.png", "player_bowtie.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

c_player_api.register_model("blue.b3d", {
	animation_speed = 30,
	textures = {"player_blue.png", "player_eyes.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

c_player_api.register_model("purple.b3d", {
	animation_speed = 30,
	textures = {"player_purple.png", "player_eyes.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

c_player_api.register_model("black.b3d", {
	animation_speed = 30,
	textures = {"player_black.png", "player_eyes.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

-- Update appearance when the player joins
minetest.register_on_joinplayer(function(player)
        local meta = player:get_meta()
        local col = meta:get_int("colour")
	if col < colours.red then
		col = colours.red
		meta:set_int("colour", col)
	end
        local colourname = colours.colour_name(col)


	-- just in case it got stuck..
	meta:set_int("teleclimbing", 0)

	-- we use the hotbar to display your current color
	player:hud_set_flags({hotbar = true, wielditem = false, crosshair = false, healthbar = false, breathbar = false})
	player:hud_set_hotbar_itemcount(1)
	player:hud_set_hotbar_selected_image("c_player_api_blank.png")

	-- try to make player invulnerable
	player:set_armor_groups({immortal=1, fall_damage_add_percent=-100})

	c_player_api.set_colour(player, colourname)

	-- there is no inventory, but we might use it later for instructions / tasks
	player:set_inventory_formspec("formspec_version[4]size[9,5]button_exit[3,4;3,0.8;Exit;OK]label[3.7,1;Important!]label[1,3.2;forum.minetest.net/viewtopic.php?50&t=27597]label[3,2.3;Read instructions here:]")
end)
