
dofile(minetest.get_modpath("ch_player_api") .. "/api.lua")

ch_player_api.register_model("red.b3d", {
	animation_speed = 30,
	textures = {"player_red.png", "player_eyes.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

ch_player_api.register_model("green.b3d", {
	animation_speed = 30,
	textures = {"player_green.png", "player_eyes.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

ch_player_api.register_model("yellow.b3d", {
	animation_speed = 30,
	textures = {"player_yellow.png", "player_eyes.png", "player_bowtie.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

ch_player_api.register_model("blue.b3d", {
	animation_speed = 30,
	textures = {"player_blue.png", "player_eyes.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

ch_player_api.register_model("purple.b3d", {
	animation_speed = 30,
	textures = {"player_purple.png", "player_eyes.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

ch_player_api.register_model("black.b3d", {
	animation_speed = 30,
	textures = {"player_black.png", "player_eyes.png"},
	animations = {
		stand     = {x = 0,   y = 48},
		walk      = {x = 55, y = 85},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 0.6,
	eye_height = 1.47,
})

-- Update appearance when the player joins
minetest.register_on_joinplayer(function(player)
        local meta = player:get_meta()
        local col = meta:get_int("colour")
	if col < ch_colours.red then
		col = ch_colours.red
		meta:set_int("colour", col)
	end
        local colourname = ch_colours.colour_name(col)


	-- just in case it got stuck..
	meta:set_int("teleclimbing", 0)

	-- we use the hotbar to display your current color
	player:hud_set_flags({hotbar = true, wielditem = false, crosshair = false, healthbar = false, breathbar = false})
	player:hud_set_hotbar_itemcount(1)
	player:hud_set_hotbar_selected_image("ch_player_api_blank.png")

	-- try to make player invulnerable
	player:set_armor_groups({immortal=1, fall_damage_add_percent=-100})

	ch_player_api.set_colour(player, colourname)

	-- there is no inventory, but we might use it later for instructions / tasks
	local content = {
		"The three terrible dragons have ravaged this land and stolen its colours!",
		"\nYou are an invincible blob, that can change colour and paint by jumping.",
		"\n\nBuild dragon altars, activate them, and wait for midnight.",
		"Gain new colours by defeating the dragons.",
		"\nLook for clues in the ruins. Learn from them, experiment.",
		"\n\nPlease bring colour back to the world.",
		"\n\n\nhttps://content.minetest.net/packages/talas/colourhop/",
		"\nhttps://gitlab.com/talas777/colourhop/"
	}
	local invform = {
		"size[15,8]",
		"bgcolor[#000000C0;true]",
		"listcolors[#00000000;#00000000;#00000000;#000000FF;#FFFFFFFF]",
		"textarea[0.25,0.25;15,8;;;",
		table.concat(content, " "),
		"]"
	}
	player:set_inventory_formspec(table.concat(invform))
end)
