-- LUALOCALS < ---------------------------------------------------------
local minetest, ch_schematics = minetest, ch_schematics
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local hgapi = _G[modname]

local room_ymin = -4017
local room_ymax = -4000

local room = ch_schematics.rooms[4]
local core = ch_schematics.room_cores[4]

hgapi.register_mapgen_shared({
		label = "generate royal rooms",
		schematics = true,
		priority = -200,
		func = function(minp, maxp, _, _, vm, _, _, _)
			if maxp.y < room_ymin then return end
			if minp.y > room_ymax then return end
			local maxa = {x=maxp.x+1, y=maxp.y+1, z=maxp.z+1}
			for x = minp.x, maxa.x, room.size.x+1 do
				for z = minp.z, maxa.z, room.size.z+1 do
					local xd = math.floor(x/(room.size.x+1)) % 8
					local zd = math.floor(z/(room.size.z+1)) % 8
					if xd == 0 and zd == 0 then
						minetest.place_schematic_on_vmanip(vm,
							{x = x, y = room_ymin, z = z}, room.schem,
							nil, nil, true)
					end
				end
			end
		end
	})
