-- LUALOCALS < ---------------------------------------------------------
local minetest, ch_schematics = minetest, ch_schematics
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local hgapi = _G[modname]

local layer1_ymin = -3115
local layer1_ymax = -3105

local layer2_ymin = -3135
local layer2_ymax = -3125

hgapi.register_mapgen_shared({
		label = "ambient light",
		priority = -100,
		func = function(minp, maxp, area, data, _, _, _, _)
			if minp.y > -3000 then return end
			local cid = minetest.get_content_id("world:blacka")
			for x = minp.x, maxp.x, 1 do
				for z = minp.z, maxp.z, 1 do
					for y = minp.y, maxp.y, 1 do
						local i = area.index(area, x, y, z)
						data[i] = cid
					end
				end
			end
		end,
	})

hgapi.register_mapgen_shared({
		label = "generate layer1",
		priority = -200,
		func = function(minp, maxp, area, data, _, _, _, _)
			if maxp.y < layer1_ymin then return end
			if minp.y > layer1_ymax then return end
			for x = minp.x, maxp.x, 1 do
				for z = minp.z, maxp.z, 1 do
					for y = minp.y, maxp.y, 1 do
						if not (y < layer1_ymin or y > layer1_ymax) then
							local i = area.index(area, x, y, z)
							data[i] = minetest.CONTENT_AIR
						end
					end
				end
			end
		end
	})

hgapi.register_mapgen_shared({
		label = "generate layer2",
		priority = -200,
		func = function(minp, maxp, area, data, _, _, _, _)
			if maxp.y < layer2_ymin then return end
			if minp.y > layer2_ymax then return end
			for x = minp.x, maxp.x, 1 do
				for z = minp.z, maxp.z, 1 do
					for y = minp.y, maxp.y, 1 do
						if not (y > layer2_ymax+1 or y < layer2_ymin) then
							local i = area.index(area, x, y, z)
							data[i] = minetest.CONTENT_AIR
						end
					end
				end
			end
		end
	})
