-- LUALOCALS < ---------------------------------------------------------
local minetest, ch_schematics = minetest, ch_schematics
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local hgapi = _G[modname]

local storage_ymin = -3015
local storage_ymax = -3000

local room = ch_schematics.rooms[1]
local core = ch_schematics.room_cores[1]

hgapi.register_mapgen_shared({
		label = "generate storages",
		schematics = true,
		priority = -200,
		func = function(minp, maxp, _, _, vm, _, _, _)
			local access_only = false
			if maxp.y < storage_ymin then
				access_only = true
			end
			if maxp.y < storage_ymin-100 then return end
			if minp.y > storage_ymax then return end
			local maxa = {x=maxp.x+1, y=maxp.y+1, z=maxp.z+1}
			for x = minp.x, maxa.x, room.size.x+1 do
				for z = minp.z, maxa.z, room.size.z+1 do
					local xd = (x/(room.size.x+1)) % 9
					local zd = (z/(room.size.z+1)) % 9
					if xd == 4 and zd == 4 then
						if not access_only then
							minetest.place_schematic_on_vmanip(vm,
								{x = x, y = storage_ymin, z = z}, ch_schematics.rooms[3].schem,
								nil, nil, true)
						end
						for l = 0, 100 do
							local c = {x=x+core.x, y=storage_ymin+core.y-l, z=z+core.z}
							vm:set_node_at({x=c.x-1,y=c.y,z=c.z-1}, {name="air"})
							vm:set_node_at({x=c.x,y=c.y,z=c.z-1}, {name="air"})
							vm:set_node_at({x=c.x+1,y=c.y,z=c.z-1}, {name="air"})
							vm:set_node_at({x=c.x-1,y=c.y,z=c.z}, {name="air"})
							vm:set_node_at({x=c.x,y=c.y,z=c.z}, {name="air"})
							vm:set_node_at({x=c.x+1,y=c.y,z=c.z}, {name="air"})
							vm:set_node_at({x=c.x-1,y=c.y,z=c.z+1}, {name="air"})
							vm:set_node_at({x=c.x,y=c.y,z=c.z+1}, {name="air"})
							vm:set_node_at({x=c.x+1,y=c.y,z=c.z+1}, {name="air"})
						end
					elseif xd == 3 and (zd >= 3 and zd <= 5) then
						if not access_only then
							minetest.place_schematic_on_vmanip(vm,
								{x = x, y = storage_ymin, z = z}, ch_schematics.rooms[2].schem,
								nil, nil, true)
						end
					elseif xd == 4 and (zd == 3 or zd == 5) then
						if not access_only then
							minetest.place_schematic_on_vmanip(vm,
								{x = x, y = storage_ymin, z = z}, ch_schematics.rooms[2].schem,
								nil, nil, true)
						end
					elseif xd == 5 and (zd >= 3 and zd <= 5) then
						if not access_only then
							minetest.place_schematic_on_vmanip(vm,
								{x = x, y = storage_ymin, z = z}, ch_schematics.rooms[2].schem,
								nil, nil, true)
						end
					else
						if not access_only then
							minetest.place_schematic_on_vmanip(vm,
								{x = x, y = storage_ymin, z = z}, room.schem,
								nil, nil, true)
							if xd == 0 or (xd == 1 and zd > 0 and zd < 8) then
								vm:set_node_at({x=x+core.x+2, y=storage_ymin+core.y, z=z+core.x}, {name = "world:blacka"})
							elseif xd == 8 or (xd == 7 and zd > 0 and zd < 8) then
								vm:set_node_at({x=x+core.x-2, y=storage_ymin+core.y, z=z+core.x}, {name = "world:blacka"})
							elseif (zd == 0 and xd ~= 0 and xd ~= 8) or (zd == 1 and xd > 1 and xd < 7) then
								vm:set_node_at({x=x+core.x, y=storage_ymin+core.y, z=z+core.x+2}, {name = "world:blacka"})
							elseif (zd == 8 and xd ~= 0 and xd ~= 8) or (zd == 7 and xd > 1 and xd < 7) then
								vm:set_node_at({x=x+core.x, y=storage_ymin+core.y, z=z+core.x-2}, {name = "world:blacka"})
							end
						end
					end
				end
			end
		end
	})
