-- LUALOCALS < ---------------------------------------------------------
local minetest, ch_schematics = minetest, ch_schematics
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local hgapi = _G[modname]

local schemkeys = {
	["."] = {name = "air", prob = 0},
	["#"] = {name = "world:black"},
	["o"] = {name = "world:yellow"},
	["+"] = {name = "world:blue"},
	["*"] = {name = "world:ambient"},
	r = {name = "buildings:red"},
	g = {name = "buildings:green"},
	b = {name = "buildings:blue"},
	y = {name = "buildings:yellow"},
	p = {name = "buildings:purple"},
	k = {name = "buildings:black"},
	x = {name = "buildings:exit_point"},
}

local clear_royal = {
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
	"*******************",
}

local room = ch_schematics.ezschematic(schemkeys,
	{
		{
			"###################",
			"###################",
			"###################",
			"#########+#########",
			"########+g+########",
			"#########+#########",
			"######+#####+######",
			"#####+g+###+g+#####",
			"######+#####+######",
			"#########+#########",
			"########+g+########",
			"#########+#########",
			"###################",
			"###################",
			"###################",
			"###################",
			"###################",
			"###################",
			"###################",
		},
		{
			"#########o#########",
			"########o#o########",
			"#######o#+#o#######",
			"######o#+++#o######",
			"#####o#+++++#o#####",
			"####o#+++++++#o####",
			"###o#+++++++++#o###",
			"##o#+++++++++++#o##",
			"###o#+++++++++#o###",
			"####o#+++++++#o####",
			"#####o#+++++#o#####",
			"######o#+++#o######",
			"#######o#+#o#######",
			"########o#o########",
			"#########o#########",
			"###################",
			"#########b#########",
			"########bgb########",
			"#########b#########",
		},
		{
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*******************",
			"*********x*********",
			"*******************",
		},
		clear_royal, clear_royal, clear_royal, clear_royal,
		clear_royal, clear_royal, clear_royal, clear_royal,
		clear_royal, clear_royal, clear_royal, clear_royal,
		clear_royal, clear_royal,
	})

local room_ymin = -4017
local room_ymax = -4000

hgapi.register_mapgen_shared({
		label = "generate royal rooms",
		ymin = room_ymin,
		ymax = room_ymax,
		func = function(minp, maxp, vm)
			local maxa = {x=maxp.x+1, y=maxp.y+1, z=maxp.z+1}
			for x = minp.x, maxa.x, 20 do
				for z = minp.z, maxa.z, 20 do
					local xd = math.floor(x/20) % 8
					local zd = math.floor(z/20) % 8
					if xd == 0 and zd == 0 then
						minetest.place_schematic_on_vmanip(vm,
							{x = x, y = room_ymin, z = z},
							room, nil, nil, true)
					end
				end
			end
		end
	})
