working_villages.func is a table with several functions:

`function working_villages.func.validate_pos(pos)`
returns the position rounded, if it is a slab/stair the position on top is given
for getting the position of the villager for pathfinding

`function working_villages.func.search_surrounding(pos, pred, searching_range)`
calls `pred(pos)` for every node within searching_range of pos
if `searching_range.h` is given the searching range will start h above pos
if `pred(pos)` returns true it will return the position
if `pred(pos)` doesn't return true at all nil will be returned

`function working_villages.func.get_back_to_searching(self)`
makes a villager switch to the SEARCH state which is default for a state_machine_job

`function working_villages.func.find_adjacent_pos(pos,pred)`
calls `pred(pos)` for every node next to pos and for pos itself
if `pred(pos)` returns true it will return the position
if `pred(pos)` doesn't return true at all false will be returned

`function working_villages.func.villager_state_machine_job(job_name,job_description,actions, sprop)`
registers a job with:
itemstring="working_villages:"..job_name
description="working_villages job : "..job_description
actions has to be a table containing the states (see example)
sprop has to be a table containing special properties:
property name   |          default            |   type  | description
night_active    =  false                      -- boolean, whether the villager should not go to sleep
search_idle     =  false                      -- boolean, whether the villager should stay where he is while searching for a state with self_condition(self) = true and search_condition(pos) = true
searching_range =  {x = 10, y = 3, z = 10}    -- table  , searching range for search_contition(pos)

example:
```

local function find_tree(p)
	local nod = minetest.get_node(p)
	return minetest.get_item_group(nod.name, "tree") > 0
end
local searching_range = {x = 10, y = 7, z = 10, h = 3}
local target = working_villages.func.search_surrounding(self.object:getpos(), find_tree, searching_range)

actions.some_state = {to_state=function(self, destination, target)
				--(opional) what to do while entering this state
				print("found place to do something at: " .. minetest.pos_to_string(destination))
				self.destination = destination
				print("my actual target is: " .. minetest.pos_to_string(target))
				self.target = target
				self:set_state("goto_dest")
			end,
			func = function(self)
				--(optional) do something every step we have this state
			end,
			self_condition=function(self)
				--(optional) return true if the villager is ready to go to this state
			end,
			search_condition=function(pos)
				--(optional) return true if you want to go to pos
				--this is used as "pred(pos) for search_surrounding(pos, pred, searching_range)"
			end,
			next_state=actions.different_state
				--(optional) go to this state if func(self) returns true or is not defined
			}
```
