minetest.register_node("sbo_wood:wood_plank", unifieddyes.def {
    description = "Wood Plank",
    tiles = { "wood_plank.png" },
    groups = { matter = 1, cracky = 3, explody = 3, moss_growable = 1 },
    walkable = true,
    sounds = sbz_api.sounds.matter(),
    on_punch = function(pos, node, puncher)
        minetest.sound_play("step", { pos = pos, gain = 1.0 })
    end,
})

minetest.register_craftitem("sbo_wood:stick", {
    description = "Stick",
    inventory_image = "stick.png",
    stack_max = 256,
})
minetest.register_craft({
    output = "sbo_wood:stick 4",
    recipe = {
        { "", "", "" },
        { "", "sbo_wood:wood_plank", "" },
        { "", "sbo_wood:wood_plank", "" }
    }
})

minetest.register_craft({
    type = "shapeless",
    output = "sbo_wood:wood_plank 4",
    recipe = { "sbz_bio:colorium_tree_core" }
})

minetest.register_craft({
    type = "shapeless",
    output = "sbo_wood:wood_plank 4",
    recipe = { "sbz_bio:colorium_tree" }
})

stairs.register("sbo_wood:wood_plank")
