quests = {}
sbz_api.quests=quests

function sbz_api.register_quest(def)
    quests[#quests + 1] = def
end

local quest_files = {
    "Introduction",
    "Emittrium",
    "Chemistry",
    "Storage",
    "Meteorites",
    "Organics",
    "Decorator",
    "Pipeworks_and_fluid_transport",
    "Reactor",
    "Jumpdrive",
    "Completionist",
    "Status_Effects"
}

local function foreach(t, f)
    for k, v in ipairs(t) do f(v) end
end

function sbz_api.quests_from_file(path)
    foreach(assert(loadfile(path))(), sbz_api.register_quest)
end

foreach(quest_files, function(name)
    sbz_api.quests_from_file(minetest.get_modpath("sbz_progression") .. "/quests/" .. name .. ".lua")
end)

function sbz_api.register_quest_to(line,quest)
    local found=false
    for i=1,#quests do
        if quests[i].type=="text" then
            if found then
                table.insert(quests,i,quest)
                return true
            elseif quests[i].title==line then
                found=true
            end
        end 
    end
    if found then
        sbz_api.register_quest(quest)
        return true
    end
    return false
end
