Hello, quest files contain spoilers.
They are also meant to be viewed in the raw form, not in the graphical form. 

# Questline: Introduction

The first questline, to introduce you to the game. Your adventure will start here.

To expand one of those questlines, use the arrow keys or double click on the questline.

## Info: General Info

### Text

By holding aux1 (usually "e"), you can sprint.  
  
You have 20 health points, you re-gain them usually eating food.  
If you die, your inventory stays with you, meaning there is no reason to worry about dying.  
  
There are several in-game commands useful in survival:  
- `/bgm_volume` \<percentage\> - sets the background music's volume  
- commands of the areas mod - protecting using areas using /protect has been disabled, but you can still do other things  
- `/drawers_fix` - if drawers appear broken just run that, command was taken from pandorabox_custom  
- `/afk` - marks you as afk  
- `/core` - teleports you to the core  
- `/playtime` - shows your, or other player's playtime  
- `/qb` - gives you the questbook if you don't have one  
- `/home` - teleports you to home  
- `/sethome` - sets your home  
- `/toggle_areas_hud` - Toggles the areas hud, may be useful if you dont want to always see it.  
- `/theme_gui` - opens the theming gui, here you can customize the theme  
  
**Recomended for small screens**  
in /theme_gui, you can disable "Force mono font", this will make the font less cool but it will make it smaller.  

### Meta

Requires: 

## Info: Navigating the inventory

### Text

This game uses unified inventory. You may be familiar with it if you have played modded minetest.  
If you aren't familiar with it, here are some things to know:  
- Top left: categories
- Left side: A display of all the items
**If you click on an item button, it will first show you what that item is used for.**  
**If you click on it a second time, it will show you how to craft that item.**
- Bottom left: Some navigation for the left side
- Bottom right: Some miscellaneous buttons.
- Top right: The player inventory and the crafting inventory. There are also some buttons related to crafting, feel free to play with them.

### Meta

Requires:

## Introduction

### Text

Welcome, player. This is the Quest Book. Here, you can check out what tasks you have to do, and the materials you will need for each quest.  
  
You can also just ignore the Quest Book if you are an experienced player.  
  
Now, to get started: look down at the core. Punching it will give you some of your first resources.  
You can also just right-click the core, it will be easier on you.  
  
These quests are in no particular order, but you might need items from one quest for another.  
The Introduction questline is designed to get you started into a couple other questlines, so it is recommended you jump between questlines occasionally.  
  
If you need to know a recipe, search the item in the inventory, and click on it, it will bring up what it can be used for or how it can be crafted.  
  
TIP: If you lose your Quest Book, you can use /qb to get it back.

### Meta

Requires: 

## A bigger platform

### Text

Isn't this one node a little too crammed? Let's do something about that.  
  
Punch the Core a little more. With nine 'Matter Dust', you can craft yourself a 'Matter Blob'.  
If you are unable to place a matter blob next to the core, try sneaking while placing it. On multiplayer servers the area around the core may be protected.  

### Meta

Requires: Introduction

## Antimatter

### Text

Unfortunately, you don't seem to be strong enough to destroy that node once you place it (Assuming you placed it already). That kind of sucks, so let's craft something that can. Craft some 'Antimatter Dust', we'll need it for later.\nDon't know how to craft it? The search bar in your inventory will help.

### Meta

Requires: Introduction

## Annihilator

### Text

Doesn't it feel weird to be holding antimatter? To break nodes you'll need a **Matter** Annihilator, you should craft it up now since it's used in some other crafts down the line.  
TIP: Half-broken Annihilators can also be used to craft with.  
Also, don't craft the **Anti**matter annihilator, you won't need it yet.

### Meta

Requires: A bigger platform, Antimatter

## Info: Bridging out

### Text

Emitters are these blue nodes scattered around the core, be careful not to confuse them with the very similar looking skybox.  
You will need an annihilator to extract resources from them, they will behave exactly the same as a core, but they will sometimes give you emittrium.  
You can craft matter platforms to have a cheaper way of bridging out.  

### Meta

Requires: Annihilator

## Charged Field

### Text

Now, then. We have one more thing to do before we can start automating. Can you guess what it is?  
That's right! We need power generation.  
  
To get going, craft yourself a Simple Charged Field.  
But listen up! Charged Fields decay over time, leaving indestructible residue (that decays in a relatively short time) behind. Since you are using a Simple Charged Field, you should expect to have energy for about 10 minutes.  
Generators use energy even when there's nothing connected to them. Since resources are infinite here, time is your resource. Let's get automating.

### Meta

Requires: Introduction

## Matter Plates

### Text

Matter Plates are often used for machinery. They are simple to craft, yet very important.  
  
You can get four Matter Plates by placing one matter blob into the crafting grid.

### Meta

Requires: A bigger platform

## Switching Station

### Text

The Switching Station is an important node, because it is the heart of any Power Grid.  
You need to have one switching station per power grid.  
Every machine needs to be connected to a switching station.  
The Switching Station also displays statistics about the Power Grid when hovered over in-world. When a machine says "no network found", it's not connected to the switching station and won't do anything.

When you right-click a switching station, you will see a summary of all the machines connected.

### Meta

Requires: Matter Plates

## Info: What conducts power?

### Text

Unlike most power systems, in Skyblock: Zero's power system, almost all machines conducts power to other machines, so machines are like wires here.  
Wires are useful when you have 2 far apart factories that you want to connect, for aesthetics, or for organization.  
The power unit Cosmic Joules is abbreviated to Cj in most interfaces.  

### Meta

Requires: 

## Automation

### Text

Finally! Automation! Let's get on that, shall we? You will need a simple matter extractor and some power for that.
TIP: Early game machines without power emit red particles.

### Meta

Requires: Annihilator, Charged Field

## Advanced Extractors

### Text

That's a shiny new machine you've got there! Do you also want to triple your production? Only for DOUBLE THE POWER? Sure you do.  
  
For Advanced Extractors you'll obviously need a Simple Matter Extractor, then four Matter Annihilators and four matter Blobs. That's a lot of resources, but this Extractor will also occasionally generate Core Dust!  
  
For the curious, an Advanced Extractor has a 4% chance of extracting core dust. This means a core dust will be extracted every 40 seconds (on average).

### Meta

Requires: Automation

## Circuitry

### Text

Circuits are important crafting components for future recipes. You'll need them for lots of recipes, and many of them too.  
  
Simple Circuits are currently your only available Circuit type, but there are different circuit types which will be used in the future. Also, all different Circuit types use Simple Circuits as their base.  
  
To craft a Simple Circuit, you'll need one core dust and one matter blob. You'll get two Simple Circuits from that craft.

### Meta

Requires: A bigger platform

## Generators

### Text

Right now, you're probably using simple charged fields to generate your power, but since they decay, they don't last forever, which is not convenient.  
  
To solve that, you can use a simple charge generator. It consumes core dust as fuel over time, and provides you with more power than simple charged fields do.  
  
However, Generators are expensive. They require 4 simple charged fields, an antimatter dust, 3 matter blobs and 1 Matter Annihilator to craft.  

### Meta

Requires: Charged Field, Antimatter

## Retaining Circuits

### Text

Retaining Circuits are a type of Circuit often used in nodes which store items, either permanently or temporarily. Circuits depend on other circuits which is why you will need a Simple Circuit to craft this Circuit.  
  
The list of materials is as follows: one Simple Circuit, one charged particle and one antimatter dust.  
  
Unlike Simple Circuits, this will only craft one Retaining Circuit.

### Meta

Requires: Antimatter, Circuitry

## Pretty Pebbles

### Text

We're making the jump from generic matter to stone now! Here is where building a space station gets fun!  
  
First, before we can make Stone nodes we will need Pebbles. They are quite difficult to make, requiring three matter blobs in a shapeless craft.  
Pebbles will unlock a lot of decorational nodes to spice up your island, as well as plenty of tech, and if you want you can even start building your own planet. It's all up to your imagination!

### Meta

Requires: A bigger platform

## Concrete Plan

### Text

Just regular old boring stone, nothing really to add here. Like, it's literally just stone. You know, the kind that would make even a rock collector yawn and say, "I've seen gravel with more personality". It sits around all day, doing nothing—no metamorphosis, no glittering crystals—just living its best sedentary life.  
  
That said, it's made using 9 pebbles.

### Meta

Requires: Pretty Pebbles

## Info: What to do next?

### Text

The questbook isn't meant to be explored linearly. You should do quests in whichever order you like.
If you have inventory issues, the storage questline is within your reach.
If you want to explore more machines, check out the emittrium and chemistry questline.
You should also check out the meteorites questline, if you don't, you will wish you saw it sooner.
If you are a decorator, there is a questline for you too.
If you want to actually automate (you know, the fun part), see the pipeworks questline. Do that as soon as you can.

You can also filter reachable quests (Quests that you can see the descriptions of, but haven't completed yet) by typing "reachable" into the questbook search bar

Tip: When setting a goal, explore other quests to see if that goal could be done faster by using the tools from those quests. 
Example: Getting the very advanced battery would be greately helped by the pipeworks questline.

### Meta

Requires: Concrete Plan
