
# Questline: Emittrium

Emittrium is a very important material when working with Cosmic Joules. This questline will teach you all about it.

## Obtain Emittrium

### Text

Do you see those blue nodes in the distance? They're called Emitters. To obtain Emittrium from them, you will have to build a bridge over to one.  
I would recommend to choose the closest one to you, but any Emitter works. Next, you'll need a Matter Annihilator. You can't destroy the Emitters, but you can chip away at them.  
  
Punch your Emitter of choice until it yields some 'Raw Emittrium'. We'll refine the Emittrium later, but for now we just need it in its raw state.  
  
Emitters have a 1/10 chance of producing Raw Emittrium, and a 9/10 chance of producing the same materials that the core does.  

### Meta

Requires: Annihilator

## Power Cables

### Text

To transfer power from generators to machines, you'll need Power Cables. You can get a power cable with a shapeless craft using one Raw Emittrium and one Matter Plate.  
The cables will connect up and supply your machines with power, looking at your machine will show 'Running' if the machine is running.  
Also, if you put a machine next to another machine, it will conduct power to that machine, so you only need power cables in some cases.  
For example, if you have one area for plants, one area for manifacturing, cables are the nicest option to bridge the areas.

### Meta

Requires: Matter Plates, Obtain Emittrium

## Starlight Collectors

### Text

Starlight Collectors turn the light of stars into power for you to use. But the stars are very faint, so you'll need a lot of these if you want to power a whole factory!

### Meta

Requires: Obtain Emittrium

## Starlight Catchers

### Text

Starlight Catchers are similar starlight collectors but more compact, generating 1Cj/s.  
But unlike starlight collectors, they need **Photon-Energy converters**, to convert their energy into usable power.  
They won't do anything if you connect them directly to a switching station, as they provide power though the photon-energy converter.  

### Meta

Requires: Starlight Collectors

## Emittrium Circuits

### Text

For some recipes related to storing or transferring power, you'll need Emittrium Circuits. 

### Meta

Requires: Matter Plates, Obtain Emittrium, Retaining Circuits

## Batteries

### Text

Sometimes, you'll need to temporarily buffer some energy. That's what the Battery is for. It stores up to 5 kCj of energy. You can craft it by surrounding a Emittrium Circuit with matter blobs.

TIP: Without batteries, all power that isn't being used for machines is wasted, with batteries you can store some of it.

### Meta

Requires: Emittrium Circuits

## Connectors

### Text

If you want to turn machines on and off, you can use Connectors. They join two networks together, and you can click on them to turn them on and off.  
IMPORTANT: Make sure that only one of the two or more joined networks has a switching station, or they will blow up until reaching one.

### Meta

Requires: Emittrium Circuits, Reinforced Matter

## Angel's Wing

### Text

The Angel's Wing can make you fly. Right-Click to use, it has 100 uses. To craft, surround a Emittrium Circuit with Stone. This recipe is temporary.

### Meta

Requires: Emittrium Circuits, Concrete Plan

## Ele Fabs

### Text

Used to manifacture various logic components.

### Meta

Requires: Antimatter, Emittrium Circuits

## Knowledge Stations

### Text

Teaches you about logic, which is not documented in this questbook but instead in the knowledge station. Good luck.

### Meta

Requires: Concrete Plan, Ele Fabs

## Movable Emitters

### Text

If you are tired of not being able to have emitters wherever you want, get a Movable Emitter. Your factory could use another Emitter, no?  
In the core of the ice planets there is a solution but be aware, you must be strong.  
  
Movable emitters can be duplicated with 8 phlogiston.  

### Meta

Requires: Planet Teleporter
