
# Questline: Emittrium Reactor

Emittrium reactors are another way of generating energy. They are a 3x3x3 cube made of reactor shells (or reactor glass), with a reactor core in the center. Some of the shells must be replaced with a reactor power port, a reactor coolant port, a reactor emittrium port and a reactor infoscreen. It consumes emittrium and water.
If it doesn't have enough coolant (water), it heats up, and bad things happen if it heats up too much.

## Reactor Shells

### Text

Reactor Shells are needed in crafting the emittrium reactor parts, and construction of the emittrium reactor.  
You can also use them for a nice decoration block that won't explode to meteorites.

### Meta

Requires: Obtain Emittrium

## Reactor Glass

### Text

Reactor Glass is needed in crafting recipes, and optionally can be used as a replacement for the reactor shell in the construction of the emittrium reactor.  
You can also use it as a nice decoration block that won't explode to meteorites.

### Meta

Requires: Emittrium Glass, Reactor Shells

## Reactor Infoscreens

### Text

A Reactor Infoscreen is needed in the construction of the emittrium reactor, and are needed to turn on the reactor.

### Meta

Requires: Reactor Glass

## Reactor Power Ports

### Text

A Reactor Power Port is needed in the construction of the emittrium reactor. They deliver the energy generated by the reactor core.

### Meta

Requires: Reactor Shells

## Reactor Coolant Ports

### Text

A Reactor Coolant Port is needed in the construction of the emittrium reactor. They need 1 water bucket/s (delivered in pipes) to sustain reactor heat.

### Meta

Requires: Fluid Storage Tanks

## Reactor Emittrium Input

### Text

A Reactor Emittrium Input is needed in the construction of the emittrium reactor. They need 16 emittrium/minute to fuel the reactor.

### Meta

Requires: Reactor Shells, Tubes

## Reactor Core

### Text

A Reactor Core is needed in the construction of the emittrium reactor. Needs to be in the center.

### Meta

Requires: Neutronium, Reactor Shells

## Building the emittrium reactor and turning it on

### Text

Build a 3x3 cube of reactor shells or reactor glass, in the center, place the core, but in place of some of these shells, build the extra blocks mentioned earlier (Emittrium input, coolant port, power port, etc.)  
  
Now, to actually turn the reactor on, click the infoscreen, then turn it on in the UI. If you have something wrong in the reactor, it will tell you.  
  
If you have multiple reactors, try pressing the re-link button if you think the infoscreen is displaying the wrong information.  
The finished reactor should look something like this (obviously, there are many more ways to build it than just this):  
\<img name=questbook_image_reactor.png\>  
In older releases, the emittrium reactor used to explode when it ran out of coolant, but this is now no longer the case.

### Meta

Requires: Reactor Shells, Reactor Infoscreens, Reactor Power Ports, Reactor Coolant Ports, Reactor Emittrium Input, Reactor Core