vampire = {}

local S = minetest.get_translator("vampire")
local NS = function(s) return s end

local path = minetest.get_modpath("playereffects")
dofile(path .. "/init.lua")

local path = minetest.get_modpath("vampire")

dofile(path .. "/items.lua")
dofile(path.. "/effects.lua")
-- Boilerplate for compatibiliity with pre-5.9.0
-- versions of minetest
local function get_setting(key, default)
	local value = minetest.settings:get("vampire." .. key)
	local num_value = tonumber(value)
	if value and not num_value then
		stamina.log("warning", "Invalid value for setting %s: %q. Using default %q.", key, value, default)
	end
	return num_value or default
end

vampire.settings = {
	daylight = get_setting("daylight", 13),
	regen_timer = get_setting("regen_timer", 0.5),
	damage_lvl = get_setting("damage_lvl", 1),
	healing_lvl = get_setting("healing_lvl", 1),
	stamina_lvl = get_setting("stamina_lvl", 1),
	duration_lvl = get_setting("duration_lvl", 300),
}
vampire.playerlist = {}
vampire.valid_food_items = {
	"mobs:meat_raw",
}

function vampire.load_setting(sname, stype, defaultval, valid_values)
	local sval
	if stype == "string" then
		sval = minetest.settings:get(sname)
	elseif stype == "bool" then
		sval = minetest.settings:get_bool(sname)
	elseif stype == "number" then
		sval = tonumber(minetest.settings:get(sname))
	end
	if sval ~= nil then
		if valid_values ~= nil then
			local valid = false
			for i=1,#valid_values do
				if sval == valid_values[i] then
					valid = true
				end
			end
			if not valid then
				minetest.log("error", "[vampire] Invalid value for "..sname.."! Using default value ("..tostring(defaultval)..").")
				return defaultval
			else
				return sval
			end
		else
			return sval
		end
	else
		return defaultval
	end
end


local function player_exists(player)
	return player ~= nil and player:is_player()
end

function vampire.round (x)
	return math.ceil(math.floor(x+0.5))
end

function vampire.getlevel(name)
	return vampire.playerlist[name].level
end

function vampire.setlevel(name, value)
	if value < 0 then
		minetest.log("info", "[vampire] Warning: level.set was called with negative value!")
		value = 0
	end
	value = vampire.round(value)
	vampire.playerlist[name].level = value
end

function vampire.levelup(name,value)
	local level = vampire.playerlist[name].level
	if level<4 and level < value then
		vampire.setlevel(name,value)
		core.chat_send_player(name, "your curse grows to level "..vampire.getlevel(name))
	end
end

-- Load the playerlist from a previous session, if available.
do
	local filepath = minetest.get_worldpath().."/vampire.mt"
	local file = io.open(filepath, "r")
	if file then
		minetest.log("action", "[vampire] vampire.mt opened.")
		local string = file:read()
		io.close(file)
		if(string ~= nil) then
			local savetable = minetest.deserialize(string)
			vampire.playerlist = savetable.playerlist
			minetest.log("action", "[vampire] vampire.mt successfully read.")
		end
	end
end

function vampire.save_to_file()
	local savetable = {}
	savetable.playerlist = vampire.playerlist

	local savestring = minetest.serialize(savetable)

	local filepath = minetest.get_worldpath().."/vampire.mt"
	local file = io.open(filepath, "w")
	if file then
		file:write(savestring)
		io.close(file)
		minetest.log("action", "[vampire] Wrote vampire data into "..filepath..".")
	else
		minetest.log("error", "[vampire] Failed to write vampire data into "..filepath..".")
	end
end

function vampire.rolldice(sides)
	return math.random(1,sides)
end

minetest.register_on_respawnplayer(function(player)
	local playername = player:get_player_name()
	vampire.setlevel(playername, 0)
	vampire.playerlist[playername].seconds = 0
end)

minetest.register_on_leaveplayer(function(player)
	local playername = player:get_player_name()
	vampire.save_to_file()
end)

minetest.register_on_shutdown(function()
	minetest.log("action", "[vampire] Server shuts down. Rescuing data into vampire.mt")
	vampire.save_to_file()
end)

minetest.register_on_joinplayer(function(player)
	local playername = player:get_player_name()
	
	if vampire.playerlist[playername] == nil then
		vampire.playerlist[playername] = {}
		vampire.playerlist[playername].level = 0
		vampire.playerlist[playername].flying = false
		vampire.playerlist[playername].seconds = 0
	end
end)

-- TODO rewrite eating function
function vampire.contains(list,element)
	for _,value in pairs(list) do
		if element==value then
			return true
		end
	end
	return false
end
function vampire.valid_food(itemstack,player)
	local item_name = itemstack:get_name()
	local player_name = player:get_player_name()
	--minetest.chat_send_player(player_name, S("@1 you cant eat @2.", player_name, item_name))
	--minetest.chat_send_player(player_name, S("eating @1", item_name))
	
	if vampire.contains(vampire.valid_food_items,item_name) or vampire.playerlist[player_name].level==0 then
		return true
	else
		minetest.chat_send_player(player_name, S("you cant eat that"))
		return false
	end
end

vampire.core_item_eat = core.do_item_eat
function core.do_item_eat(hp_change, replace_with_item, itemstack, user, pointed_thing)
	if vampire.valid_food(itemstack,user) then
		vampire.core_item_eat(hp_change, replace_with_item, itemstack, user, pointed_thing)
	end
end

vampire.regen_timer = 0
function vampire.sundamage(player)
	local name = player:get_player_name()
	local level = vampire.getlevel(name)
	local dice = vampire.rolldice(6)
	if level>=dice then
		local hp = player:get_hp()
		local sun = core.get_natural_light(player:get_pos())
		if vampire.settings.daylight and sun then
			if sun >= vampire.settings.daylight then
				player:set_hp(hp - vampire.settings.damage_lvl)
			end
		end
	end
end
-- GLOBAL STEP
minetest.register_globalstep(function(dtime)
	vampire.regen_timer = vampire.regen_timer + dtime
	if vampire.regen_timer >= vampire.settings.regen_timer then
		local factor = math.floor(vampire.regen_timer / vampire.settings.regen_timer)
		local players = minetest.get_connected_players()
		for i=1, #players do
			local name = players[i]:get_player_name()
			if vampire.playerlist[name] ~= nil then
				if players[i]:get_hp() > 0 then
					vampire.sundamage(players[i])
				end
			end
		end
		vampire.regen_timer = vampire.regen_timer % vampire.settings.regen_timer
	end
end)

minetest.register_chatcommand( "vampire", {
	description = S("show you current level of vampirism"),
	func = function( player_name , param )
		local player = minetest.get_player_by_name( player_name )
		
		if not player then
			return false, S("Player not found!")
		end

		local level = vampire.playerlist[player_name].level
		if level==0 then
			--level = 1
			--vampire.setlevel(player_name,1)
		end
		core.chat_send_player(player_name,"level "..level)
	end
} )
minetest.register_chatcommand( "fly", {
	description = S("show you current level of vampirism"),
	func = function( player_name , param )
		local player = minetest.get_player_by_name( player_name )
		
		if not player then
			return false, S("Player not found!")
		end
		local level = vampire.playerlist[player_name].level

		if vampire.playerlist[player_name].flying then
			vampire.fly(player_name,false)
		elseif level>=3 then
			vampire.fly(player_name,true)
		else
			vampire.fly(player_name,false)
		end
		if vampire.playerlist[player_name].flying then
			core.chat_send_player(player_name,"flying on ")
		else
			core.chat_send_player(player_name,"flying off ")
		end
	end
} )
