
minetest.log("action", "[Wallgoo] Mod loaded.")
dofile(minetest.get_modpath("wallygoo2") .. "/init1.lua")
dofile(minetest.get_modpath("wallygoo2") .. "/research.lua")
dofile(minetest.get_modpath("wallygoo2") .. "/portal.lua")

---Nodes
minetest.register_craftitem("wallygoo2:goo", {
    description = "Wallgoo",
    inventory_image = "wallgoo_goo.png",
})


minetest.register_node("wallygoo2:splat", {
    description = "Wallgoo Splat",
    drawtype = "plantlike",
    tiles = {"wallgoo_splat.png"},
    inventory_image = "wallgoo_splat.png",
    wield_image = "wallgoo_splat.png",
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
    groups = {snappy = 3, flammable = 2, attached_node = 1},
    sounds = default.node_sound_leaves_defaults(),
    drop = "wallygoo2:goo",
})


minetest.register_node("wallygoo2:basic_block", {
    description = "Wallgoo Block",
    tiles = {"wallgoo_block.png"},
    groups = {cracky = 3, oddly_breakable_by_hand = 2},
    sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("wallygoo2:brick", {
    description = "Wallgoo Brick",
    tiles = {"wallgoo_brick.png"},
    groups = {cracky = 2},
    sounds = default.node_sound_stone_defaults(),
})

minetest.register_craftitem("wallygoo2:sandwich", {
    description = "Wallgoo Sandwich",
    inventory_image = "wallgoo_sandwich.png",
    on_use = minetest.item_eat(6),  -- restores 6 HP
}); minetest.register_craftitem("wallygoo2:stick", {

    description = "Wallgoo Stick",
    inventory_image = "wallgoo_stick.png",
})
minetest.register_node("wallygoo2:tree", {
    description = "Wallgoo Tree Trunk",
    tiles = {"wallgoo_tree_top.png", "wallgoo_tree_top.png", "wallgoo_tree_side.png"},
    groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1},
    sounds = default.node_sound_wood_defaults(),
})
minetest.register_node("wallygoo2:sapling", {
    description = "Wallgoo Sapling",
    drawtype = "plantlike",
    tiles = {"wallgoo_sapling.png"},
    inventory_image = "wallgoo_sapling.png",
    wield_image = "wallgoo_sapling.png",
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
    groups = {snappy = 2, dig_immediate = 3, flammable = 2, attached_node = 1, sapling = 1},
    sounds = default.node_sound_leaves_defaults(),
})


minetest.register_node("wallygoo2:leaves", {
    description = "Wallgoo Leaves",
    drawtype = "allfaces_optional",
    waving = 1,
    tiles = {"wallgoo_leaves.png"},
    paramtype = "light",
    light_source = 5,
    groups = {snappy = 3, leafdecay = 3, flammable = 2},
    sounds = default.node_sound_leaves_defaults(),
    drop = {
        max_items = 1,
        items = {
            {items = {"wallgoo:stick"}, rarity = 2},
            {items = {"wallgoo:sapling"}, rarity = 5},
        },
    },
})
minetest.register_node("wallygoo2:planks", {
    description = "Wallgoo Planks",
    tiles = {"wallgoo_planks.png"},
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2},
    sounds = default.node_sound_wood_defaults(),
})

minetest.register_node("wallygoo2:shrine", {
    description = "Wallgoo Shrine",
    tiles = {
        "wallgoo_shrine_top.png",
        "wallgoo_shrine_bottom.png",
        "wallgoo_shrine_side.png"
    },
    groups = {oddly_breakable_by_hand = 3},
    sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("wallygoo2:shrine_glass", {
    description = "Shrine Glass",
    drawtype = "glasslike",
    tiles = {"wallgoo_shrine_glass.png"},
    use_texture_alpha = "blend",
    paramtype = "light",
    sunlight_propagates = true,
    groups = {cracky = 3, oddly_breakable_by_hand = 2},
    sounds = default.node_sound_glass_defaults(),
})
minetest.register_node("wallygoo2:shrine_glow", {
    description = "Shrine Glow",
    tiles = {"wallgoo_shrine_glow.png"},
    light_source = 12,
    paramtype = "light",
    groups = {cracky = 2, oddly_breakable_by_hand = 1},
    sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("wallygoo2:trapdoor", {
    description = "Wallgoo Trapdoor (Closed)",
    drawtype = "nodebox",
    tiles = {"wallgoo_trapdoor.png"},
    paramtype = "light",
    paramtype2 = "facedir",
    groups = {choppy = 2},
    sounds = default.node_sound_wood_defaults(),
    drop = "wallgoo:trapdoor",
    node_box = {
        type = "fixed",
        fixed = {
            {-0.5, -0.5, -0.5, 0.5, -0.375, 0.5}, -- thin horizontal slab
        },
    },
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        minetest.swap_node(pos, {
            name = "wallygoo2:trapdoor_open",
            param2 = node.param2,
        })
    end,
    on_place = function(itemstack, placer, pointed_thing)
        local pos = pointed_thing.above
        minetest.set_node(pos, {name = "wallygoo2:trapdoor", param2 = 0})
        return itemstack
    end,
})
minetest.register_node("wallygoo2:trapdoor_open", {
    description = "Wallgoo Trapdoor (Open)",
    drawtype = "nodebox",
    tiles = {"wallgoo_trapdoor.png"},
    paramtype = "light",
    paramtype2 = "facedir",
    groups = {choppy = 2, not_in_creative_inventory = 1},
    sounds = default.node_sound_wood_defaults(),
    drop = "wallygoo2:trapdoor", -- always drops the closed version
    node_box = {
        type = "fixed",
        fixed = {
            {0.375, -0.5, -0.5, 0.5, 0.5, 0.5}, -- vertical flap
        },
    },
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        minetest.swap_node(pos, {
            name = "wallygoo2:trapdoor",
            param2 = node.param2,
        })
    end,
})


-- Example of a complete after_place_node function

minetest.register_node("wallygoo2:example_block", {
    description = "Example Block with Placement Logic",
    tiles = {"default_stone.png"},
    groups = {cracky = 3},
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        local function set(dx, dy, dz, nodename)
            local target_pos = vector.add(pos, {x = dx, y = dy, z = dz})
            minetest.set_node(target_pos, {name = nodename})
        end

        -- Example usage
        set(1, 0, 0, "default:torch")

        -- Add more structure logic here if needed
    end,  -- closes after_place_node function
})       -- closes register_node call

local function place_wallgoo_shrine(pos)
    local function set(dx, dy, dz, nodename)
        local target_pos = vector.add(pos, {x = dx, y = dy, z = dz})
        minetest.set_node(target_pos, {name = nodename})
    end

    -- Layer 0 (Base)
    for x = -2, 2 do
        for z = -2, 2 do
            set(x, 0, z, "wallygoo2:brick")
        end
    end

    -- Layer 1 (Walls + Glass)
    for x = -2, 2 do
        for z = -2, 2 do
            if math.abs(x) == 2 or math.abs(z) == 2 then
                set(x, 1, z, "wallygoo2:brick")
            elseif x == 0 and z == 0 then
                set(x, 1, z, "wallygoo2:shrine")
            else
                set(x, 1, z, "wallygoo2:shrine_glass")
            end
        end
    end

    -- Layer 2 (Glow Accents)
    set(-2, 2, -2, "wallygoo2:shrine_glow")
    set( 2, 2, -2, "wallygoo2:shrine_glow")
    set(-2, 2,  2, "wallygoo2:shrine_glow")
    set( 2, 2,  2, "wallygoo2:shrine_glow")

    -- Layer 3 (Roof)
    for x = -2, 2 do
        for z = -2, 2 do
            set(x, 3, z, "wallygoo2:brick")
        end
    end

    minetest.log("action", "[Wallgoo] Shrine structure spawned at " .. minetest.pos_to_string(pos))
end


local function register_wallgoo_tool(name, desc, texture, recipe)
    minetest.register_tool("wallygoo2:" .. name, {
        description = desc,
        inventory_image = texture,
        tool_capabilities = {
            full_punch_interval = 1.0,
            max_drop_level = 1,
            groupcaps = {
                cracky = {
                    times = {[1] = 2.0, [2] = 1.0, [3] = 0.5},
                    uses = 20,
                    maxlevel = 2
                },
            },
            damage_groups = {fleshy = 4},
        },
        groups = {wallgoo = 1},
    })

    minetest.register_craft({
        output = "wallygoo2:" .. name,
        recipe = recipe,
    })
end
minetest.register_craft({
    output = "wallygoo2:trapdoor",
    recipe = {
        {"wallgoo:planks", "wallgoo:planks", "wallgoo:planks"},
    }
})

---spawning
minetest.register_on_generated(function(minp, maxp, seed)
    local tree_nodes = {
        "default:tree", "default:jungletree", "default:pine_tree",
        "default:acacia_tree", "default:aspen_tree",
        "default:leaves", "default:jungleleaves", "default:pine_needles",
        "default:acacia_leaves", "default:aspen_leaves"
    }

    local positions = minetest.find_nodes_in_area(minp, maxp, tree_nodes)

    for _, pos in ipairs(positions) do
        if math.random() < 0.03 then  -- 3% chance per tree part
            local above = {x = pos.x, y = pos.y + 1, z = pos.z}
            if minetest.get_node(above).name == "air" then
                minetest.set_node(above, {name = "wallygoo2:splat"})
            end
        end
    end
end)

after_place_node = function(pos, placer, itemstack, pointed_thing)
    local function set(dx, dy, dz, nodename)
        local target_pos = vector.add(pos, {x = dx, y = dy, z = dz})
        minetest.set_node(target_pos, {name = nodename})
    end

    -- Layer 0 (Base)
    for x = -2, 2 do
        for z = -2, 2 do
            set(x, 0, z, "wallygoo2:brick")
        end
    end

    -- Layer 1 (Walls + Glass)
    for x = -2, 2 do
        for z = -2, 2 do
            if math.abs(x) == 2 or math.abs(z) == 2 then
                set(x, 1, z, "wallygoo2:brick")
            elseif x == 0 and z == 0 then
                set(x, 1, z, "wallygoo2:shrine")
            else
                set(x, 1, z, "wallygoo2:shrine_glass")
            end
        end
    end

    -- Layer 2 (Glow Accents)
    set(-2, 2, -2, "wallygoo2:shrine_glow")
    set( 2, 2, -2, "wallygoo2:shrine_glow")
    set(-2, 2,  2, "wallygoo2:shrine_glow")
    set( 2, 2,  2, "wallygoo2:shrine_glow")

    -- Layer 3 (Roof)
    for x = -2, 2 do
        for z = -2, 2 do
            set(x, 3, z, "wallygoo2:brick")
        end
    end

    minetest.log("action", "[Wallgoo] Shrine structure spawned at " .. minetest.pos_to_string(pos))
end



local shrine_positions = shrine_positions or {}
minetest.register_on_generated(function(minp, maxp, seed)
    local attempts =20
    -- Try placing up to 3 shrines per chunk

    for i = 1, attempts do
        if math.random() > 0.02 then
            -- Skip this attempt (controls rarity)
        else
            local x = math.random(minp.x, maxp.x)
            local z = math.random(minp.z, maxp.z)

            -- Find ground level
            for y = maxp.y, minp.y, -1 do
                local pos = {x = x, y = y, z = z}
                local node = minetest.get_node(pos)
                if minetest.registered_nodes[node.name]
                   and minetest.registered_nodes[node.name].walkable then
                    local shrine_pos = {x = x, y = y + 1, z = z}
                    place_wallgoo_shrine(shrine_pos)
                    minetest.chat_send_all("Shrine spawned at " .. minetest.pos_to_string(shrine_pos))
table.insert(shrine_positions, shrine_pos)

                    break
                end
            end
        end
    end
end)



---crafting
minetest.register_craft({
    output = "wallygoo2:basic_block",
    recipe = {
        {"wallygoo2:goo", "wallygoo2:goo", "wallygoo2:goo"},
        {"wallygoo2:goo", "wallygoo2:goo", "wallygoo2:goo"},
        {"wallygoo2:goo", "wallygoo2:goo", "wallygoo2:goo"},
    }
})

minetest.register_craft({
    type = "cooking",
    output = "wallygoo2:brick",
    recipe = "wallygoo2:basic_block",
    cooktime = 5,
})
minetest.register_craft({
    output = "wallygoo2:sandwich",
    recipe = {
        {"farming:bread"},
        {"wallgoo:goo"},
    }
})
register_wallgoo_tool("shovel", "Wallgoo Shovel", "wallgoo_shovel.png", {
    {"", "wallygoo2:brick", ""},
    {"", "wallygoo2:stick", ""},
    {"", "wallygoo2:stick", ""},
})

register_wallgoo_tool("pickaxe", "Wallgoo Pickaxe", "wallgoo_pickaxe.png", {
    {"wallygoo2:brick", "wallygoo2:brick", "wallygoo2:brick"},
    {"", "wallygoo2:stick", ""},
    {"", "wallygoo2:stick", ""},
})

register_wallgoo_tool("axe", "Wallgoo Axe", "wallgoo_axe.png", {
    {"wallygoo2:brick", "wallygoo2:brick", ""},
    {"wallygoo2:brick", "wallygoo2:stick", ""},
    {"", "wallygoo2:stick", ""},
})

register_wallgoo_tool("sword", "Wallgoo Sword", "wallgoo_sword.png", {
    {"", "wallygoo2:brick", ""},
    {"", "wallygoo2:brick", ""},
    {"", "wallygoo2:stick", ""},
})
minetest.register_craft({
    output = "wallygoo2:planks 4",
    recipe = {
        {"wallygoo2:tree"},
    }
})
minetest.register_craft({
    output = "wallygoo2:stick 4",
    recipe = {
        {"wallygoo2:planks"},
        {"wallygoo2:planks"},
    }
})
minetest.register_craft({
    type = "fuel",
    recipe = "wallygoo2:planks",
    burntime = 10,
})
minetest.register_craft({
    output = "wallygoo2:sapling",
    recipe = {
        {"wallygoo2:goo"},
        {"wallygoo2:goo"},
        {"wallygoo2:goo"},
    }
})
minetest.register_craft({
    output = "wallygoo2:shrine",
    recipe = {
        {"wallygoo2:brick", "wallygoo2:goo", "wallygoo2:brick"},
        {"wallygoo2:brick", "wallygoo2:planks", "wallygoo2:brick"},
        {"wallygoo2:brick", "wallygoo2:brick", "wallygoo2:brick"},
    }
}) 
minetest.register_craft({
    output = "wallygoo2:shrine_glass 4",
    recipe = {
        {"wallygoo2:goo", "default:glass", "wallygoo2:goo"},
    }
})

minetest.register_craft({
    output = "wallygoo2:shrine_glow",
    recipe = {
        {"wallygoo2:goo", "default:torch", "wallygoo2:goo"},
    }
})
minetest.register_craft({
    output = "wallygoo2:shrine_spawner",
    recipe = {
        {"wallygoo2:brick", "wallygoo2:brick", "wallygoo2:brick"},
        {"wallygoo:2shrine_glass", "wallygoo2:shrine", "wallygoo2:shrine_glow"},
        {"wallygoo2:brick", "wallygoo2:brick", "wallygoo2:brick"},
    }
})
minetest.register_craft({
    output = "wallygoo2:trapdoor",
    recipe = {
        {"wallygoo2:planks", "wallygoo:2planks", "wallygoo2:planks"},
    }
})



---block modifers

minetest.register_abm({
    label = "Wallgoo Sapling Growth",
    nodenames = {"wallygoo2:sapling"},
    interval = 10, -- seconds between checks
    chance = 5,    -- 1 in 5 chance per interval
    action = function(pos, node)
        local light = minetest.get_node_light(pos)
        if not light or light < 13 then
            return -- too dark to grow
        end

        -- Check if there's space above
        local above = vector.add(pos, {x = 0, y = 1, z = 0})
        local above_node = minetest.get_node_or_nil(above)
        if above_node and above_node.name ~= "air" then
            return -- blocked
        end

        -- Replace sapling with tree trunk and top
        minetest.set_node(pos, {name = "wallygoo2:tree"})
        minetest.set_node(above, {name = "wallygoo2:tree"})

        -- Optionally add leaves around the top
        local leaf_positions = {
            {x = 1, y = 1, z = 0}, {x = -1, y = 1, z = 0},
            {x = 0, y = 1, z = 1}, {x = 0, y = 1, z = -1},
            {x = 0, y = 2, z = 0}
        }
        for _, offset in ipairs(leaf_positions) do
            local leaf_pos = vector.add(pos, offset)
            if minetest.get_node(leaf_pos).name == "air" then
                minetest.set_node(leaf_pos, {name = "wallygoo2:leaves"})
            end
        end
    end,
})

---test commands
local shrine_positions = {}
local function place_wallgoo_shrine(pos)
    -- Example structure logic
    local function set(dx, dy, dz, nodename)
        local target_pos = vector.add(pos, {x = dx, y = dy, z = dz})
        minetest.set_node(target_pos, {name = nodename})
    end

    -- Layer 0 (Base)
    for x = -2, 2 do
        for z = -2, 2 do
            set(x, 0, z, "wallygoo2:brick")
        end
    end

    -- Layer 1 (Walls + Glass)
    for x = -2, 2 do
        for z = -2, 2 do
            if math.abs(x) == 2 or math.abs(z) == 2 then
                set(x, 1, z, "wallygoo2:brick")
            elseif x == 0 and z == 0 then
                set(x, 1, z, "wallygoo2:shrine")
            else
                set(x, 1, z, "wallygoo2:shrine_glass")
            end
        end
    end

    -- Layer 2 (Glow Accents)
    set(-2, 2, -2, "wallygoo2:shrine_glow")
    set( 2, 2, -2, "wallygoo2:shrine_glow")
    set(-2, 2,  2, "wallygoo2:shrine_glow")
    set( 2, 2,  2, "wallygoo2:shrine_glow")

    -- Layer 3 (Roof)
    for x = -2, 2 do
        for z = -2, 2 do
            set(x, 3, z, "wallygoo2:brick")
        end
    end

    minetest.log("action", "[Wallgoo] Shrine structure spawned at " .. minetest.pos_to_string(pos))
end

local shrine_positions = {}

local function place_wallgoo_shrine(pos)
    local function set(dx, dy, dz, nodename)
        local target_pos = vector.add(pos, {x = dx, y = dy, z = dz})
        minetest.set_node(target_pos, {name = nodename})
    end

    -- Base
    for x = -2, 2 do
        for z = -2, 2 do
            set(x, 0, z, "wallygoo2:brick")
        end
    end

    -- Walls + Shrine Core
    for x = -2, 2 do
        for z = -2, 2 do
            if math.abs(x) == 2 or math.abs(z) == 2 then
                set(x, 1, z, "wallygoo2:brick")
            elseif x == 0 and z == 0 then
                set(x, 1, z, "wallygoo2:shrine")
            else
                set(x, 1, z, "wallygoo2:shrine_glass")
            end
        end
    end

    -- Glow Accents
    set(-2, 2, -2, "wallygoo2:shrine_glow")
    set( 2, 2, -2, "wallygoo2:shrine_glow")
    set(-2, 2,  2, "wallygoo2:shrine_glow")
    set( 2, 2,  2, "wallygoo2:shrine_glow")

    -- Roof
    for x = -2, 2 do
        for z = -2, 2 do
            set(x, 3, z, "wallygoo2:brick")
        end
    end

    table.insert(shrine_positions, pos)
    minetest.log("action", "[Wallgoo] Shrine spawned at " .. minetest.pos_to_string(pos))
end

minetest.register_chatcommand("spawn_wallgoo_shrine", {
    description = "Spawn a Wallgoo Shrine at your feet",
    privs = {server = true},
    func = function(name)
        local player = minetest.get_player_by_name(name)
        if not player then return false, "Player not found." end

        local pos = vector.round(player:get_pos())
        pos.y = pos.y + 1
        place_wallgoo_shrine(pos)
        return true, "Shrine placed!"
    end,
})

minetest.register_chatcommand("find_shrine", {
    description = "Teleport to the nearest Wallgoo shrine",
    func = function(name)
        local player = minetest.get_player_by_name(name)
        if not player then return false, "Player not found." end

        local pos = player:get_pos()
        local nearest = nil
        local min_dist = math.huge

        for _, shrine_pos in ipairs(shrine_positions) do
            local dist = vector.distance(pos, shrine_pos)
            if dist < min_dist then
                min_dist = dist
                nearest = shrine_pos
            end
        end

        if nearest then
            player:set_pos(nearest)
            return true, "Teleported to shrine at " .. minetest.pos_to_string(nearest)
        else
            return false, "No shrines found."
        end
    end,
})

